/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.annotation.DataClass;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.utils.CollectionUtil;
import org.neo4j.gds.utils.StringFormatting;

@DataClass
@Value.Immutable(singleton=true)
public abstract class AbstractPropertyMappings
implements Iterable<PropertyMapping> {
    public abstract List<PropertyMapping> mappings();

    public static PropertyMappings of(PropertyMapping ... mappings) {
        if (mappings == null) {
            return PropertyMappings.of();
        }
        return PropertyMappings.of(Arrays.asList(mappings));
    }

    public static PropertyMappings fromObject(Object relPropertyMapping) {
        return AbstractPropertyMappings.fromObject(relPropertyMapping, Aggregation.DEFAULT);
    }

    public static PropertyMappings fromObject(Object relPropertyMapping, Aggregation defaultAggregation) {
        if (relPropertyMapping instanceof PropertyMappings) {
            PropertyMappings properties = (PropertyMappings)relPropertyMapping;
            return PropertyMappings.builder().from(properties).withDefaultAggregation(defaultAggregation).build();
        }
        if (relPropertyMapping instanceof String) {
            String propertyMapping = (String)relPropertyMapping;
            return AbstractPropertyMappings.fromObject(Collections.singletonMap(propertyMapping, propertyMapping), defaultAggregation);
        }
        if (relPropertyMapping instanceof List) {
            Builder builder = PropertyMappings.builder().withDefaultAggregation(defaultAggregation);
            for (Object mapping : (List)relPropertyMapping) {
                List<PropertyMapping> propertyMappings = AbstractPropertyMappings.fromObject(mapping, defaultAggregation).mappings();
                for (PropertyMapping propertyMapping : propertyMappings) {
                    if (builder.mappings != null && builder.mappings.contains(propertyMapping)) {
                        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate property key `%s`", (Object[])new Object[]{propertyMapping.propertyKey()}));
                    }
                    builder.addMapping(propertyMapping);
                }
            }
            return ((PropertyMappings.Builder)builder).build();
        }
        if (relPropertyMapping instanceof Map) {
            Builder builder = PropertyMappings.builder().withDefaultAggregation(defaultAggregation);
            ((Map)relPropertyMapping).forEach((? super K key, ? super V spec) -> {
                PropertyMapping propertyMapping = PropertyMapping.fromObject(key, spec);
                builder.addMapping(propertyMapping);
            });
            return ((PropertyMappings.Builder)builder).build();
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected String or Map for property mappings. Got %s.", (Object[])new Object[]{relPropertyMapping.getClass().getSimpleName()}));
    }

    public Stream<PropertyMapping> stream() {
        return this.mappings().stream();
    }

    @Override
    public Iterator<PropertyMapping> iterator() {
        return this.mappings().iterator();
    }

    public Stream<IntObjectPair<PropertyMapping>> enumerate() {
        return CollectionUtil.enumerate(this.mappings());
    }

    public boolean hasMappings() {
        return !this.mappings().isEmpty();
    }

    public int numberOfMappings() {
        return this.mappings().size();
    }

    public boolean isEmpty() {
        return this.mappings().isEmpty();
    }

    public Map<String, Object> toObject(boolean includeAggregation) {
        return this.stream().map(mapping -> mapping.toObject(includeAggregation)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate key %s", (Object[])new Object[]{u}));
        }, LinkedHashMap::new));
    }

    public PropertyMappings mergeWith(PropertyMappings other) {
        if (!this.hasMappings()) {
            return other;
        }
        if (!other.hasMappings()) {
            return PropertyMappings.copyOf(this);
        }
        Builder builder = PropertyMappings.builder();
        builder.addMappings(Stream.concat(this.stream(), other.stream()).distinct());
        return builder.build();
    }

    @Value.Check
    void checkForAggregationMixing() {
        long noneStrategyCount = this.stream().filter(d -> d.aggregation() == Aggregation.NONE).count();
        if (noneStrategyCount > 0L && noneStrategyCount < (long)this.numberOfMappings()) {
            throw new IllegalArgumentException("Conflicting relationship property aggregations, it is not allowed to mix `NONE` with aggregations.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends PropertyMappings.Builder {
        private Aggregation aggregation = Aggregation.DEFAULT;

        Builder() {
        }

        void addMappings(Stream<? extends PropertyMapping> propertyMappings) {
            Objects.requireNonNull(propertyMappings, "propertyMappings must not be null.");
            propertyMappings.forEach(this::addMapping);
        }

        public Builder withDefaultAggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation must not be empty");
            return this;
        }

        @Override
        public PropertyMappings build() {
            if (this.aggregation != Aggregation.DEFAULT && this.mappings != null) {
                ListIterator<PropertyMapping> iter = this.mappings.listIterator();
                while (iter.hasNext()) {
                    PropertyMapping mapping = ((PropertyMapping)iter.next()).setNonDefaultAggregation(this.aggregation);
                    iter.set(mapping);
                }
            }
            return super.build();
        }
    }
}

