/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AbstractProjections;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.annotation.DataClass;
import org.neo4j.gds.utils.StringFormatting;

@DataClass
@Value.Immutable(singleton=true)
public abstract class AbstractNodeProjections
extends AbstractProjections<NodeLabel, NodeProjection> {
    public static final NodeProjections ALL = AbstractNodeProjections.create(Collections.singletonMap(NodeLabel.ALL_NODES, NodeProjection.all()));

    @Override
    public abstract Map<NodeLabel, NodeProjection> projections();

    public static NodeProjections fromObject(Object object) {
        if (object == null) {
            return AbstractNodeProjections.fromMap(Collections.emptyMap());
        }
        if (object instanceof NodeProjections) {
            return (NodeProjections)object;
        }
        if (object instanceof String) {
            return AbstractNodeProjections.fromString((String)object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return AbstractNodeProjections.fromMap(map);
        }
        if (object instanceof Iterable) {
            Iterable list = (Iterable)object;
            return AbstractNodeProjections.fromList(list);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a node projection out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static NodeProjections fromString(@Nullable String labelString) {
        AbstractNodeProjections.validateIdentifierName(labelString);
        if (StringFormatting.isEmpty((String)labelString)) {
            AbstractNodeProjections.create(Collections.emptyMap());
        }
        if (labelString.equals("*")) {
            return AbstractNodeProjections.create(Collections.singletonMap(NodeLabel.ALL_NODES, NodeProjection.all()));
        }
        NodeLabel nodeLabel = new NodeLabel(labelString);
        NodeProjection projection = NodeProjection.fromString(labelString);
        return AbstractNodeProjections.create(Collections.singletonMap(nodeLabel, projection));
    }

    private static NodeProjections fromMap(Map<String, ?> map) {
        LinkedHashMap<NodeLabel, NodeProjection> projections = new LinkedHashMap<NodeLabel, NodeProjection>();
        map.forEach((name, spec) -> {
            NodeLabel nodeLabel = new NodeLabel((String)name);
            NodeProjection projection = NodeProjection.fromObject(spec, nodeLabel);
            if (projections.put(nodeLabel, projection) != null) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate key: %s", (Object[])new Object[]{name}));
            }
        });
        return AbstractNodeProjections.create(projections);
    }

    private static NodeProjections fromList(Iterable<?> items) {
        LinkedHashMap<NodeLabel, NodeProjection> projections = new LinkedHashMap<NodeLabel, NodeProjection>();
        for (Object item : items) {
            NodeProjections nodeProjections = AbstractNodeProjections.fromObject(item);
            projections.putAll(nodeProjections.projections());
        }
        return AbstractNodeProjections.create(projections);
    }

    public static NodeProjections create(Map<NodeLabel, NodeProjection> projections) {
        if (projections.isEmpty()) {
            throw new IllegalArgumentException("An empty node projection was given; at least one node label must be projected.");
        }
        return NodeProjections.of(Collections.unmodifiableMap(projections));
    }

    public static NodeProjections single(NodeLabel label, NodeProjection projection) {
        return NodeProjections.of(Map.of(label, projection));
    }

    public static NodeProjections all() {
        return ALL;
    }

    public NodeProjections addPropertyMappings(PropertyMappings mappings) {
        if (!mappings.hasMappings()) {
            return NodeProjections.copyOf(this);
        }
        Map<NodeLabel, NodeProjection> newProjections = this.projections().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NodeProjection)e.getValue()).withAdditionalPropertyMappings(mappings)));
        if (newProjections.isEmpty()) {
            newProjections.put(NodeLabel.ALL_NODES, NodeProjection.all().withAdditionalPropertyMappings(mappings));
        }
        return AbstractNodeProjections.create(newProjections);
    }

    public String labelProjection() {
        if (this.isEmpty()) {
            return "";
        }
        return this.projections().values().stream().map(NodeProjection::label).collect(Collectors.joining(", "));
    }

    public boolean isEmpty() {
        return this == NodeProjections.of();
    }

    public Map<String, Object> toObject() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        this.projections().forEach((identifier, projection) -> value.put(identifier.name, projection.toObject()));
        return value;
    }

    private static void validateIdentifierName(String identifier) {
        if (identifier.equals(NodeLabel.ALL_NODES.name())) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s is a reserved node label and may not be used", (Object[])new Object[]{NodeLabel.ALL_NODES.name()}));
        }
    }
}

