/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.mem;

import org.neo4j.gds.mem.MemoryUsage;

public final class HugeArrays {
    public static int oversizeInt(int minTargetSize, int bytesPerElement) {
        return Math.toIntExact(HugeArrays.oversize(minTargetSize, bytesPerElement));
    }

    public static long oversize(long minTargetSize, int bytesPerElement) {
        if (minTargetSize == 0L) {
            return 0L;
        }
        long extra = minTargetSize >> 3;
        if (extra < 3L) {
            extra = 3L;
        }
        long newSize = minTargetSize + extra;
        if (MemoryUsage.BYTES_OBJECT_REF == 8) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1L & 0x7FFFFFFEL;
                }
                case 2: {
                    return newSize + 3L & 0x7FFFFFFCL;
                }
                case 1: {
                    return newSize + 7L & 0x7FFFFFF8L;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1L & 0x7FFFFFFEL;
            }
            case 1: {
                return newSize + 3L & 0x7FFFFFFCL;
            }
        }
        return newSize;
    }

    private HugeArrays() {
        throw new UnsupportedOperationException("No instances");
    }
}

