/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import org.neo4j.gds.mem.BitUtil;

public final class PageUtil {
    public static final int PAGE_SIZE_4KB = 4096;
    public static final int PAGE_SIZE_32KB = 32768;

    public static int pageSizeFor(int pageSizeInBytes, int sizeOfElement) {
        assert (BitUtil.isPowerOfTwo((int)sizeOfElement));
        return pageSizeInBytes >> Integer.numberOfTrailingZeros(sizeOfElement);
    }

    public static int numPagesFor(long capacity, int pageSize) {
        int pageShift = Integer.numberOfTrailingZeros(pageSize);
        int pageMask = pageSize - 1;
        return PageUtil.numPagesFor(capacity, pageShift, pageMask);
    }

    public static int numPagesFor(long capacity, int pageShift, long pageMask) {
        long numPages = capacity + pageMask >>> pageShift;
        assert (numPages <= Integer.MAX_VALUE) : "pageSize=" + (pageMask + 1L) + " is too small for such as capacity: " + capacity;
        return (int)numPages;
    }

    public static long capacityFor(int numPages, int pageShift) {
        return (long)numPages << pageShift;
    }

    public static int pageIndex(long index, int pageShift) {
        return (int)(index >>> pageShift);
    }

    public static int indexInPage(long index, int pageMask) {
        return (int)(index & (long)pageMask);
    }

    public static int indexInPage(long index, long pageMask) {
        return (int)(index & pageMask);
    }

    private PageUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

