/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseShortArrayArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseShortArrayArraySon
implements HugeSparseShortArrayArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final short[][][] pages;
    private final short[] defaultValue;

    private HugeSparseShortArrayArraySon(long capacity, short[][][] pages, short[] defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public short[] get(long index) {
        short[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            short[] value = page[indexInPage];
            return value == null ? this.defaultValue : value;
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        short[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != null && !Arrays.equals(page[indexInPage], this.defaultValue);
        }
        return false;
    }

    @Override
    public DrainingIterator<short[][]> drainingIterator() {
        return new DrainingIterator<short[][]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseShortArrayArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(short[][].class);
        private final ReentrantLock newPageLock;
        private final short[] defaultValue;
        private AtomicReferenceArray<short[][]> pages;
        private final LongConsumer trackAllocation;

        GrowingBuilder(short[] defaultValue, long initialCapacity, LongConsumer trackAllocation) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
            this.trackAllocation = trackAllocation;
        }

        @Override
        public void set(long index, short[] value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseShortArrayArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            short[][][] newPages = new short[numPages][][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseShortArrayArraySon(capacity, newPages, this.defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<short[][]> newPages = new AtomicReferenceArray<short[][]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    short[][] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private short[][] getPage(int pageIndex) {
            short[][] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short[][] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                Object page = this.pages.get(pageIndex);
                if (page != null) {
                    short[][] sArray = page;
                    return sArray;
                }
                this.trackAllocation.accept(PAGE_SIZE_IN_BYTES);
                page = new short[4096][];
                this.pages.set(pageIndex, (short[][])page);
                Object object = page;
                return object;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

