/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseIntArrayArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseIntArrayArraySon
implements HugeSparseIntArrayArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final int[][][] pages;
    private final int[] defaultValue;

    private HugeSparseIntArrayArraySon(long capacity, int[][][] pages, int[] defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public int[] get(long index) {
        int[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int[] value = page[indexInPage];
            return value == null ? this.defaultValue : value;
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        int[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != null && !Arrays.equals(page[indexInPage], this.defaultValue);
        }
        return false;
    }

    @Override
    public DrainingIterator<int[][]> drainingIterator() {
        return new DrainingIterator<int[][]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseIntArrayArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(int[][].class);
        private final ReentrantLock newPageLock;
        private final int[] defaultValue;
        private AtomicReferenceArray<int[][]> pages;
        private final LongConsumer trackAllocation;

        GrowingBuilder(int[] defaultValue, long initialCapacity, LongConsumer trackAllocation) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
            this.trackAllocation = trackAllocation;
        }

        @Override
        public void set(long index, int[] value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseIntArrayArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            int[][][] newPages = new int[numPages][][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseIntArrayArraySon(capacity, newPages, this.defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<int[][]> newPages = new AtomicReferenceArray<int[][]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    int[][] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private int[][] getPage(int pageIndex) {
            int[][] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[][] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                Object page = this.pages.get(pageIndex);
                if (page != null) {
                    int[][] nArray = page;
                    return nArray;
                }
                this.trackAllocation.accept(PAGE_SIZE_IN_BYTES);
                page = new int[4096][];
                this.pages.set(pageIndex, (int[][])page);
                Object object = page;
                return object;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

