/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseFloatArrayArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseFloatArrayArraySon
implements HugeSparseFloatArrayArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final float[][][] pages;
    private final float[] defaultValue;

    private HugeSparseFloatArrayArraySon(long capacity, float[][][] pages, float[] defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public float[] get(long index) {
        float[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            float[] value = page[indexInPage];
            return value == null ? this.defaultValue : value;
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        float[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != null && !Arrays.equals(page[indexInPage], this.defaultValue);
        }
        return false;
    }

    @Override
    public DrainingIterator<float[][]> drainingIterator() {
        return new DrainingIterator<float[][]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseFloatArrayArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(float[][].class);
        private final ReentrantLock newPageLock;
        private final float[] defaultValue;
        private AtomicReferenceArray<float[][]> pages;
        private final LongConsumer trackAllocation;

        GrowingBuilder(float[] defaultValue, long initialCapacity, LongConsumer trackAllocation) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
            this.trackAllocation = trackAllocation;
        }

        @Override
        public void set(long index, float[] value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseFloatArrayArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            float[][][] newPages = new float[numPages][][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseFloatArrayArraySon(capacity, newPages, this.defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<float[][]> newPages = new AtomicReferenceArray<float[][]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    float[][] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private float[][] getPage(int pageIndex) {
            float[][] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float[][] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                Object page = this.pages.get(pageIndex);
                if (page != null) {
                    float[][] fArray = page;
                    return fArray;
                }
                this.trackAllocation.accept(PAGE_SIZE_IN_BYTES);
                page = new float[4096][];
                this.pages.set(pageIndex, (float[][])page);
                Object object = page;
                return object;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

