/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseByteArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseByteArraySon
implements HugeSparseByteArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final byte[][] pages;
    private final byte defaultValue;

    private HugeSparseByteArraySon(long capacity, byte[][] pages, byte defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public byte get(long index) {
        byte[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        byte[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != this.defaultValue;
        }
        return false;
    }

    @Override
    public DrainingIterator<byte[]> drainingIterator() {
        return new DrainingIterator<byte[]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseByteArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(byte[].class);
        private final ReentrantLock newPageLock;
        private final byte defaultValue;
        private AtomicReferenceArray<byte[]> pages;
        private final LongConsumer trackAllocation;

        GrowingBuilder(byte defaultValue, long initialCapacity, LongConsumer trackAllocation) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
            this.trackAllocation = trackAllocation;
        }

        @Override
        public void set(long index, byte value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseByteArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            byte[][] newPages = new byte[numPages][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseByteArraySon(capacity, newPages, this.defaultValue);
        }

        @Override
        public boolean setIfAbsent(long index, byte value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            byte storedValue = ARRAY_HANDLE.compareAndExchange(this.getPage(pageIndex), indexInPage, this.defaultValue, value);
            return storedValue == this.defaultValue;
        }

        @Override
        public void addTo(long index, byte value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            byte[] page = this.getPage(pageIndex);
            byte expectedCurrentValue = ARRAY_HANDLE.getVolatile(page, indexInPage);
            byte newValueToStore;
            byte actualCurrentValue;
            while ((actualCurrentValue = ARRAY_HANDLE.compareAndExchange(page, indexInPage, expectedCurrentValue, newValueToStore = (byte)(expectedCurrentValue + value))) != expectedCurrentValue) {
                expectedCurrentValue = actualCurrentValue;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<byte[]> newPages = new AtomicReferenceArray<byte[]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    byte[] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private byte[] getPage(int pageIndex) {
            byte[] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                byte[] page = this.pages.get(pageIndex);
                if (page != null) {
                    byte[] byArray = page;
                    return byArray;
                }
                this.trackAllocation.accept(PAGE_SIZE_IN_BYTES);
                page = new byte[4096];
                if (this.defaultValue != 0) {
                    Arrays.fill(page, this.defaultValue);
                }
                this.pages.set(pageIndex, page);
                byte[] byArray = page;
                return byArray;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

