/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicInteger;

public final class DrainingIterator<PAGE> {
    private final VarHandle arrayHandle;
    private final PAGE[] pages;
    private final int pageSize;
    private final AtomicInteger globalPageId;

    DrainingIterator(PAGE[] pages, int pageSize) {
        this.pages = pages;
        this.pageSize = pageSize;
        this.globalPageId = new AtomicInteger(0);
        this.arrayHandle = MethodHandles.arrayElementVarHandle(pages.getClass());
    }

    public DrainingBatch<PAGE> drainingBatch() {
        return new DrainingBatch();
    }

    public boolean next(DrainingBatch<PAGE> reuseBatch) {
        int nextPageId = 0;
        Object nextPage = null;
        while (nextPage == null) {
            nextPageId = this.globalPageId.getAndIncrement();
            if (nextPageId >= this.pages.length) {
                return false;
            }
            nextPage = this.pages[nextPageId];
        }
        this.arrayHandle.setVolatile(this.pages, nextPageId, null);
        reuseBatch.reset(nextPage, (long)nextPageId * (long)this.pageSize);
        return true;
    }

    public static class DrainingBatch<PAGE> {
        public PAGE page;
        public long offset;

        void reset(PAGE page, long offset) {
            this.page = page;
            this.offset = offset;
        }
    }
}

