/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.wcc;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.wcc.WccWriteConfig;

public final class WccWriteConfigImpl
implements WccWriteConfig {
    private final boolean consecutiveIds;
    private final double threshold;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final boolean sudo;
    @Nullable
    private final String seedProperty;
    @Nullable
    private final String relationshipWeightProperty;
    private final String writeProperty;
    private final int writeConcurrency;

    public WccWriteConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.consecutiveIds = config.getBool("consecutiveIds", WccWriteConfig.super.consecutiveIds());
        this.threshold = config.getDouble("threshold", WccWriteConfig.super.threshold());
        this.concurrency = config.getInt("concurrency", WccWriteConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)WccWriteConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)WccWriteConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sudo = config.getBool("sudo", WccWriteConfig.super.sudo());
        this.seedProperty = StringUtils.trimToNull((String)config.getString("seedProperty", WccWriteConfig.super.seedProperty()));
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", WccWriteConfig.super.relationshipWeightProperty()));
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)StringUtils.trimToNull((String)config.requireString("writeProperty")));
        this.writeConcurrency = config.getInt("writeConcurrency", WccWriteConfig.super.writeConcurrency());
        this.validate();
        this.validateConcurrency();
    }

    @Override
    public boolean consecutiveIds() {
        return this.consecutiveIds;
    }

    @Override
    public double threshold() {
        return this.threshold;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("consecutiveIds", "threshold", "concurrency", "relationshipTypes", "nodeLabels", "sudo", "seedProperty", "relationshipWeightProperty", "writeProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("consecutiveIds", this.consecutiveIds());
        map.put("threshold", this.threshold());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("seedProperty", this.seedProperty());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    @Nullable
    public String seedProperty() {
        return this.seedProperty;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }
}

