/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.wcc;

import org.immutables.value.Value;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.SeedConfig;

public interface WccBaseConfig
extends AlgoBaseConfig,
SeedConfig,
RelationshipWeightConfig {
    @Value.Default
    default public boolean consecutiveIds() {
        return false;
    }

    @Value.Default
    default public double threshold() {
        return 0.0;
    }

    @Configuration.Ignore
    default public boolean isIncremental() {
        return this.seedProperty() != null;
    }

    @Value.Check
    default public void validate() {
        if (this.threshold() > 0.0 && this.relationshipWeightProperty() == null) {
            throw new IllegalArgumentException("Specifying a threshold requires `relationshipWeightProperty` to be set.");
        }
        if (this.isIncremental() && this.consecutiveIds()) {
            throw new IllegalArgumentException("Seeding and the `consecutiveIds` option cannot be used at the same time.");
        }
    }
}

