/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.wcc;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.api.RelationshipWithPropertyConsumer;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.dss.DisjointSetStruct;
import org.neo4j.graphalgo.core.utils.paged.dss.HugeAtomicDisjointSetStruct;
import org.neo4j.graphalgo.wcc.WccBaseConfig;

public class Wcc
extends Algorithm<Wcc, DisjointSetStruct> {
    private final WccBaseConfig config;
    private final NodeProperties initialComponents;
    private final ExecutorService executor;
    private final AllocationTracker tracker;
    private final long nodeCount;
    private final long batchSize;
    private final int threadSize;
    private Graph graph;

    public static MemoryEstimation memoryEstimation(boolean incremental) {
        return MemoryEstimations.builder(Wcc.class).add("dss", HugeAtomicDisjointSetStruct.memoryEstimation((boolean)incremental)).build();
    }

    public Wcc(Graph graph, ExecutorService executor, int minBatchSize, WccBaseConfig config, ProgressLogger progressLogger, AllocationTracker tracker) {
        this.graph = graph;
        this.config = config;
        this.initialComponents = config.isIncremental() ? graph.nodeProperties(config.seedProperty()) : null;
        this.executor = executor;
        this.tracker = tracker;
        this.nodeCount = graph.nodeCount();
        this.batchSize = ParallelUtil.adjustedBatchSize((long)this.nodeCount, (int)config.concurrency(), (long)minBatchSize, (long)Integer.MAX_VALUE);
        long threadSize = ParallelUtil.threadCount((long)this.batchSize, (long)this.nodeCount);
        if (threadSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Too many nodes (%d) to run union find with the given concurrency (%d) and batchSize (%d)", this.nodeCount, config.concurrency(), this.batchSize));
        }
        this.threadSize = (int)threadSize;
        this.progressLogger = progressLogger;
    }

    public DisjointSetStruct compute() {
        this.progressLogger.logMessage(":: Start");
        long nodeCount = this.graph.nodeCount();
        HugeAtomicDisjointSetStruct dss = this.config.isIncremental() ? new HugeAtomicDisjointSetStruct(nodeCount, this.initialComponents, this.tracker, this.config.concurrency()) : new HugeAtomicDisjointSetStruct(nodeCount, this.tracker, this.config.concurrency());
        ArrayList<WCCTask> tasks = new ArrayList<WCCTask>(this.threadSize);
        for (long i = 0L; i < this.nodeCount; i += this.batchSize) {
            WCCTask wccTask = Double.isNaN(this.threshold()) || this.threshold() == 0.0 ? new WCCTask((DisjointSetStruct)dss, i) : new WCCWithThresholdTask(this.threshold(), (DisjointSetStruct)dss, i);
            tasks.add(wccTask);
        }
        ParallelUtil.run(tasks, (ExecutorService)this.executor);
        this.progressLogger.logMessage(":: Finished");
        return dss;
    }

    public Wcc me() {
        return this;
    }

    public void release() {
        this.graph = null;
    }

    public double threshold() {
        return this.config.threshold();
    }

    private static double defaultWeight(double threshold) {
        return threshold + 1.0;
    }

    private class WCCWithThresholdTask
    extends WCCTask
    implements RelationshipWithPropertyConsumer {
        private final double threshold;

        WCCWithThresholdTask(double threshold, DisjointSetStruct struct, long offset) {
            super(struct, offset);
            this.threshold = threshold;
        }

        @Override
        void compute(long node) {
            this.rels.forEachRelationship(node, Wcc.defaultWeight(this.threshold), (RelationshipWithPropertyConsumer)this);
        }

        public boolean accept(long sourceNodeId, long targetNodeId, double property) {
            if (property > this.threshold) {
                this.struct.union(sourceNodeId, targetNodeId);
            }
            return true;
        }
    }

    private class WCCTask
    implements Runnable,
    RelationshipConsumer {
        final DisjointSetStruct struct;
        final RelationshipIterator rels;
        private final long offset;
        private final long end;

        WCCTask(DisjointSetStruct struct, long offset) {
            this.struct = struct;
            this.rels = Wcc.this.graph.concurrentCopy();
            this.offset = offset;
            this.end = Math.min(offset + Wcc.this.batchSize, Wcc.this.nodeCount);
        }

        @Override
        public void run() {
            for (long node = this.offset; node < this.end; ++node) {
                this.compute(node);
                if (node % 10000L == 0L) {
                    Wcc.this.assertRunning();
                }
                Wcc.this.getProgressLogger().logProgress((long)Wcc.this.graph.degree(node));
            }
        }

        void compute(long node) {
            this.rels.forEachRelationship(node, (RelationshipConsumer)this);
        }

        public boolean accept(long sourceNodeId, long targetNodeId) {
            this.struct.union(sourceNodeId, targetNodeId);
            return true;
        }
    }
}

