/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.pagerank.ComputeStep;
import org.neo4j.graphalgo.pagerank.DegreeCache;
import org.neo4j.graphalgo.pagerank.DegreeComputer;
import org.neo4j.graphalgo.pagerank.PageRankVariant;
import org.neo4j.graphalgo.pagerank.WeightedComputeStep;
import org.neo4j.graphalgo.pagerank.WeightedDegreeComputer;

public class WeightedPageRankVariant
implements PageRankVariant {
    private final boolean cacheWeights;

    WeightedPageRankVariant(boolean cacheWeights) {
        this.cacheWeights = cacheWeights;
    }

    public ComputeStep createComputeStep(double dampingFactor, double toleranceValue, long[] sourceNodeIds, Graph graph, AllocationTracker tracker, int partitionCount, long start, DegreeCache aggregatedDegrees, long nodeCount, ProgressLogger progressLogger) {
        return new WeightedComputeStep(dampingFactor, sourceNodeIds, graph, tracker, partitionCount, start, aggregatedDegrees, progressLogger);
    }

    public DegreeComputer degreeComputer(Graph graph) {
        return new WeightedDegreeComputer(graph, this.cacheWeights);
    }
}

