/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import java.util.concurrent.ExecutorService;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.pagerank.DegreeCache;
import org.neo4j.graphalgo.pagerank.DegreeComputer;
import org.neo4j.graphalgo.pagerank.WeightedDegreeCentrality;

public class WeightedDegreeComputer
implements DegreeComputer {
    private final Graph graph;
    private final boolean cacheWeights;

    WeightedDegreeComputer(Graph graph, boolean cacheWeights) {
        this.graph = graph;
        this.cacheWeights = cacheWeights;
    }

    public DegreeCache degree(ExecutorService executor, int concurrency, AllocationTracker tracker) {
        WeightedDegreeCentrality degreeCentrality = new WeightedDegreeCentrality(this.graph, concurrency, this.cacheWeights, executor, tracker);
        degreeCentrality.compute();
        return new DegreeCache(degreeCentrality.degrees(), degreeCentrality.weights(), -1.0);
    }
}

