/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;

public class WeightedDegreeCentrality
extends Algorithm<WeightedDegreeCentrality, WeightedDegreeCentrality> {
    private final long nodeCount;
    private Graph graph;
    private final ExecutorService executor;
    private final int concurrency;
    private volatile AtomicInteger nodeQueue = new AtomicInteger();
    private final boolean cacheWeights;
    private HugeDoubleArray degrees;
    private HugeObjectArray<HugeDoubleArray> weights;
    private AllocationTracker tracker;

    public WeightedDegreeCentrality(Graph graph, int concurrency, boolean cacheWeights, ExecutorService executor, AllocationTracker tracker) {
        this.cacheWeights = cacheWeights;
        if (!graph.hasRelationshipProperty()) {
            throw new UnsupportedOperationException("WeightedDegreeCentrality requires a weight property to be loaded.");
        }
        this.tracker = tracker;
        if (concurrency <= 0) {
            concurrency = 4;
        }
        this.graph = graph;
        this.executor = executor;
        this.concurrency = concurrency;
        this.nodeCount = graph.nodeCount();
        this.degrees = HugeDoubleArray.newArray((long)this.nodeCount, (AllocationTracker)tracker);
        this.weights = HugeObjectArray.newArray(HugeDoubleArray.class, (long)this.nodeCount, (AllocationTracker)tracker);
    }

    public WeightedDegreeCentrality compute() {
        this.nodeQueue.set(0);
        long batchSize = ParallelUtil.adjustedBatchSize((long)this.nodeCount, (long)this.concurrency);
        long threadSize = ParallelUtil.threadCount((long)batchSize, (long)this.nodeCount);
        if (threadSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("A concurrency of %d is too small to divide graph into at most Integer.MAX_VALUE tasks", this.concurrency));
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>((int)threadSize);
        int i = 0;
        while ((long)i < threadSize) {
            if (this.cacheWeights) {
                tasks.add(new CacheDegreeTask());
            } else {
                tasks.add(new DegreeTask());
            }
            ++i;
        }
        ParallelUtil.runWithConcurrency((int)this.concurrency, tasks, (ExecutorService)this.executor);
        return this;
    }

    public WeightedDegreeCentrality me() {
        return this;
    }

    public void release() {
        this.graph = null;
    }

    public HugeDoubleArray degrees() {
        return this.degrees;
    }

    public HugeObjectArray<HugeDoubleArray> weights() {
        return this.weights;
    }

    private class CacheDegreeTask
    implements Runnable {
        private CacheDegreeTask() {
        }

        @Override
        public void run() {
            RelationshipIterator threadLocalGraph = WeightedDegreeCentrality.this.graph.concurrentCopy();
            double[] weightedDegree = new double[1];
            int nodeId;
            while ((long)(nodeId = WeightedDegreeCentrality.this.nodeQueue.getAndIncrement()) < WeightedDegreeCentrality.this.nodeCount && WeightedDegreeCentrality.this.running()) {
                HugeDoubleArray nodeWeights = HugeDoubleArray.newArray((long)WeightedDegreeCentrality.this.graph.degree((long)nodeId), (AllocationTracker)WeightedDegreeCentrality.this.tracker);
                WeightedDegreeCentrality.this.weights.set((long)nodeId, (Object)nodeWeights);
                int[] index = new int[]{0};
                weightedDegree[0] = 0.0;
                threadLocalGraph.forEachRelationship((long)nodeId, Double.NaN, (sourceNodeId, targetNodeId, weight) -> {
                    if (weight > 0.0) {
                        weightedDegree[0] = weightedDegree[0] + weight;
                    }
                    nodeWeights.set((long)index[0], weight);
                    index[0] = index[0] + 1;
                    return true;
                });
                WeightedDegreeCentrality.this.degrees.set((long)nodeId, weightedDegree[0]);
            }
            return;
        }
    }

    private class DegreeTask
    implements Runnable {
        private DegreeTask() {
        }

        @Override
        public void run() {
            RelationshipIterator threadLocalGraph = WeightedDegreeCentrality.this.graph.concurrentCopy();
            int nodeId;
            while ((long)(nodeId = WeightedDegreeCentrality.this.nodeQueue.getAndIncrement()) < WeightedDegreeCentrality.this.nodeCount && WeightedDegreeCentrality.this.running()) {
                double[] weightedDegree = new double[1];
                threadLocalGraph.forEachRelationship((long)nodeId, Double.NaN, (sourceNodeId, targetNodeId, weight) -> {
                    if (weight > 0.0) {
                        weightedDegree[0] = weightedDegree[0] + weight;
                    }
                    return true;
                });
                WeightedDegreeCentrality.this.degrees.set((long)nodeId, weightedDegree[0]);
            }
            return;
        }
    }
}

