/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.api.RelationshipWithPropertyConsumer;
import org.neo4j.graphalgo.core.utils.ArrayUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.pagerank.BaseComputeStep;
import org.neo4j.graphalgo.pagerank.DegreeCache;

public class WeightedComputeStep
extends BaseComputeStep
implements RelationshipWithPropertyConsumer {
    private final HugeDoubleArray aggregatedDegrees;
    private double sumOfWeights;
    private double delta;

    WeightedComputeStep(double dampingFactor, long[] sourceNodeIds, Graph graph, AllocationTracker tracker, int partitionSize, long startNode, DegreeCache degreeCache, ProgressLogger progressLogger) {
        super(dampingFactor, sourceNodeIds, graph, tracker, partitionSize, startNode, progressLogger);
        this.aggregatedDegrees = degreeCache.aggregatedDegrees();
    }

    void singleIteration() {
        long startNode = this.startNode;
        long endNode = this.endNode;
        RelationshipIterator rels = this.relationshipIterator;
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            int degree;
            this.delta = this.deltas[(int)(nodeId - startNode)];
            if (this.delta > 0.0 && (degree = this.degrees.degree(nodeId)) > 0) {
                this.sumOfWeights = this.aggregatedDegrees.get(nodeId);
                rels.forEachRelationship(nodeId, 1.0, (RelationshipWithPropertyConsumer)this);
            }
            this.progressLogger.logProgress((long)this.graph.degree(nodeId));
        }
    }

    public boolean accept(long sourceNodeId, long targetNodeId, double property) {
        double proportion;
        float srcRankDelta;
        if (property > 0.0 && (srcRankDelta = (float)(this.delta * (proportion = property / this.sumOfWeights))) != 0.0f) {
            int idx = ArrayUtil.binaryLookup((long)targetNodeId, (long[])this.starts);
            float[] fArray = this.nextScores[idx];
            int n = (int)(targetNodeId - this.starts[idx]);
            fArray[n] = fArray[n] + srcRankDelta;
        }
        return true;
    }
}

