/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.pagerank.PageRankMutateConfig;
import org.neo4j.graphdb.Node;

public final class PageRankMutateConfigImpl
implements PageRankMutateConfig {
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final boolean cacheWeights;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final boolean sudo;
    @Nullable
    private final String relationshipWeightProperty;
    private final List<Node> sourceNodes;
    private final String mutateProperty;

    public PageRankMutateConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.tolerance = config.getDouble("tolerance", PageRankMutateConfig.super.tolerance());
        this.maxIterations = config.getInt("maxIterations", PageRankMutateConfig.super.maxIterations());
        this.dampingFactor = config.getDouble("dampingFactor", PageRankMutateConfig.super.dampingFactor());
        this.cacheWeights = config.getBool("cacheWeights", PageRankMutateConfig.super.cacheWeights());
        this.concurrency = config.getInt("concurrency", PageRankMutateConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)PageRankMutateConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)PageRankMutateConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sudo = config.getBool("sudo", PageRankMutateConfig.super.sudo());
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", PageRankMutateConfig.super.relationshipWeightProperty()));
        this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)config.getChecked("sourceNodes", (Object)PageRankMutateConfig.super.sourceNodes(), List.class));
        this.mutateProperty = (String)CypherMapWrapper.failOnNull((String)"mutateProperty", (Object)StringUtils.trimToNull((String)config.requireString("mutateProperty")));
        this.validateConcurrency();
    }

    public double tolerance() {
        return this.tolerance;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public double dampingFactor() {
        return this.dampingFactor;
    }

    public boolean cacheWeights() {
        return this.cacheWeights;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("tolerance", "maxIterations", "dampingFactor", "cacheWeights", "concurrency", "relationshipTypes", "nodeLabels", "sudo", "relationshipWeightProperty", "sourceNodes", "mutateProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("tolerance", this.tolerance());
        map.put("maxIterations", this.maxIterations());
        map.put("dampingFactor", this.dampingFactor());
        map.put("cacheWeights", this.cacheWeights());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("sourceNodes", this.sourceNodes());
        map.put("mutateProperty", this.mutateProperty());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<Node> sourceNodes() {
        return this.sourceNodes;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }
}

