/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.BitUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.pagerank.PageRank;
import org.neo4j.graphalgo.pagerank.PageRankAlgorithmType;
import org.neo4j.graphalgo.pagerank.PageRankBaseConfig;
import org.neo4j.logging.Log;

public class PageRankFactory<CONFIG extends PageRankBaseConfig>
extends AlgorithmFactory<PageRank, CONFIG> {
    private final PageRankAlgorithmType algorithmType;

    public PageRankFactory() {
        this(PageRankAlgorithmType.NON_WEIGHTED);
    }

    public PageRankFactory(PageRankAlgorithmType algorithmType) {
        this.algorithmType = algorithmType;
    }

    public PageRank build(Graph graph, PageRankBaseConfig configuration, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.relationshipCount(), ((Object)((Object)this)).getClass().getSimpleName(), configuration.concurrency());
        return this.algorithmType.create(graph, configuration.sourceNodeIds(), configuration, configuration.concurrency(), Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(PageRank.class).add(MemoryEstimations.setup((String)"computeSteps", (dimensions, concurrency) -> {
            long nodeCount = dimensions.nodeCount();
            long nodesPerThread = BitUtil.ceilDiv((long)nodeCount, (long)concurrency);
            if (nodesPerThread > 0x3FFFFFEFL) {
                concurrency = (int)BitUtil.ceilDiv((long)nodeCount, (long)0x3FFFFFEFL);
                nodesPerThread = BitUtil.ceilDiv((long)nodeCount, (long)concurrency);
                while (nodesPerThread > 0x3FFFFFEFL) {
                    nodesPerThread = BitUtil.ceilDiv((long)nodeCount, (long)(++concurrency));
                }
            }
            return MemoryEstimations.builder(PageRank.ComputeSteps.class).perThread("scores[] wrapper", MemoryUsage::sizeOfObjectArray).perThread("starts[]", MemoryUsage::sizeOfLongArray).perThread("lengths[]", MemoryUsage::sizeOfLongArray).perThread("list of computeSteps", MemoryUsage::sizeOfObjectArray).perThread("ComputeStep", this.algorithmType.memoryEstimation()).build();
        })).build();
    }
}

