/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ArrayUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.pagerank.BaseComputeStep;

public class NonWeightedComputeStep
extends BaseComputeStep
implements RelationshipConsumer {
    private float srcRankDelta;

    NonWeightedComputeStep(double dampingFactor, double toleranceValue, long[] sourceNodeIds, Graph graph, AllocationTracker tracker, int partitionSize, long startNode, ProgressLogger progressLogger) {
        super(dampingFactor, toleranceValue, sourceNodeIds, graph, tracker, partitionSize, startNode, progressLogger);
    }

    void singleIteration() {
        long startNode = this.startNode;
        long endNode = this.endNode;
        RelationshipIterator rels = this.relationshipIterator;
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            int degree;
            double delta = this.deltas[(int)(nodeId - startNode)];
            if (delta > 0.0 && (degree = this.degrees.degree(nodeId)) > 0) {
                this.srcRankDelta = (float)(delta / (double)degree);
                rels.forEachRelationship(nodeId, (RelationshipConsumer)this);
            }
            this.progressLogger.logProgress((long)this.graph.degree(nodeId));
        }
    }

    public boolean accept(long sourceNodeId, long targetNodeId) {
        if (this.srcRankDelta != 0.0f) {
            int idx = ArrayUtil.binaryLookup((long)targetNodeId, (long[])this.starts);
            float[] fArray = this.nextScores[idx];
            int n = (int)(targetNodeId - this.starts[idx]);
            fArray[n] = fArray[n] + this.srcRankDelta;
        }
        return true;
    }
}

