/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.pagerank;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.IterationsConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.ToleranceConfig;
import org.neo4j.graphalgo.pagerank.PageRankBaseConfig;
import org.neo4j.graphalgo.pagerank.PageRankStreamConfig;

@Generated(from="PageRankStreamConfig", generator="Immutables")
public final class ImmutablePageRankStreamConfig
implements PageRankStreamConfig {
    private final String username;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    @Nullable
    private final String relationshipWeightProperty;
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final boolean cacheWeights;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageRankStreamConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.cacheWeights(cacheWeights);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.cacheWeights = this.initShim.cacheWeights();
        this.initShim = null;
    }

    private ImmutablePageRankStreamConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.cacheWeights(cacheWeights);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.cacheWeights = this.initShim.cacheWeights();
        this.initShim = null;
    }

    private ImmutablePageRankStreamConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutablePageRankStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutablePageRankStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.dampingFactorIsSet()) {
            this.initShim.dampingFactor(builder.dampingFactor);
        }
        if (builder.cacheWeightsIsSet()) {
            this.initShim.cacheWeights(builder.cacheWeights);
        }
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.cacheWeights = this.initShim.cacheWeights();
        this.initShim = null;
    }

    private ImmutablePageRankStreamConfig(String username, boolean sudo, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        this.initShim.username(username);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.cacheWeights(cacheWeights);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.cacheWeights = this.initShim.cacheWeights();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return PageRankStreamConfig.super.username();
    }

    private boolean sudoInitialize() {
        return PageRankStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return PageRankStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return PageRankStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return PageRankStreamConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return PageRankStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return PageRankStreamConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return PageRankStreamConfig.super.relationshipWeightProperty();
    }

    private double toleranceInitialize() {
        return PageRankStreamConfig.super.tolerance();
    }

    private int maxIterationsInitialize() {
        return PageRankStreamConfig.super.maxIterations();
    }

    private double dampingFactorInitialize() {
        return PageRankStreamConfig.super.dampingFactor();
    }

    private boolean cacheWeightsInitialize() {
        return PageRankStreamConfig.super.cacheWeights();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    public double dampingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dampingFactor() : this.dampingFactor;
    }

    public boolean cacheWeights() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheWeights() : this.cacheWeights;
    }

    public final ImmutablePageRankStreamConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, value, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(elements, true, false));
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(elements, true, false));
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.tolerance, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, value, this.maxIterations, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, value, this.dampingFactor, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withDampingFactor(double value) {
        if (Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, value, this.cacheWeights));
    }

    public final ImmutablePageRankStreamConfig withCacheWeights(boolean value) {
        if (this.cacheWeights == value) {
            return this;
        }
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.dampingFactor, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRankStreamConfig && this.equalTo((ImmutablePageRankStreamConfig)another);
    }

    private boolean equalTo(ImmutablePageRankStreamConfig another) {
        return this.username.equals(another.username) && this.sudo == another.sudo && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && this.maxIterations == another.maxIterations && Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(another.dampingFactor) && this.cacheWeights == another.cacheWeights;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Double.hashCode(this.dampingFactor);
        h += (h << 5) + Boolean.hashCode(this.cacheWeights);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PageRankStreamConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("tolerance=").append(this.tolerance);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("dampingFactor=").append(this.dampingFactor);
        builder.append(", ");
        builder.append("cacheWeights=").append(this.cacheWeights);
        return builder.append("}").toString();
    }

    public static PageRankStreamConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        return ImmutablePageRankStreamConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, tolerance, maxIterations, dampingFactor, cacheWeights);
    }

    public static PageRankStreamConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, tolerance, maxIterations, dampingFactor, cacheWeights));
    }

    public static PageRankStreamConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, double dampingFactor, boolean cacheWeights) {
        return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, tolerance, maxIterations, dampingFactor, cacheWeights));
    }

    private static ImmutablePageRankStreamConfig validate(ImmutablePageRankStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static PageRankStreamConfig copyOf(PageRankStreamConfig instance) {
        if (instance instanceof ImmutablePageRankStreamConfig) {
            return (ImmutablePageRankStreamConfig)instance;
        }
        return ImmutablePageRankStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PageRankStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 4L;
        private static final long OPT_BIT_NODE_LABELS = 8L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 16L;
        private static final long OPT_BIT_TOLERANCE = 32L;
        private static final long OPT_BIT_MAX_ITERATIONS = 64L;
        private static final long OPT_BIT_DAMPING_FACTOR = 128L;
        private static final long OPT_BIT_CACHE_WEIGHTS = 256L;
        private long optBits;
        private String username;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private String relationshipWeightProperty;
        private double tolerance;
        private int maxIterations;
        private double dampingFactor;
        private boolean cacheWeights;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String relationshipWeightPropertyValue;
            BaseConfig instance;
            long bits = 0L;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
                this.username(instance.username());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof PageRankBaseConfig) {
                instance = (PageRankBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.dampingFactor(instance.dampingFactor());
                this.cacheWeights(instance.cacheWeights());
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder cacheWeights(boolean cacheWeights) {
            this.cacheWeights = cacheWeights;
            this.optBits |= 0x100L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.username = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.relationshipWeightProperty = null;
            this.tolerance = 0.0;
            this.maxIterations = 0;
            this.dampingFactor = 0.0;
            this.cacheWeights = false;
            return this;
        }

        public PageRankStreamConfig build() {
            return ImmutablePageRankStreamConfig.validate(new ImmutablePageRankStreamConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean dampingFactorIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean cacheWeightsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }
    }

    @Generated(from="PageRankStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte dampingFactorBuildStage = 0;
        private double dampingFactor;
        private byte cacheWeightsBuildStage = 0;
        private boolean cacheWeights;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutablePageRankStreamConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePageRankStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePageRankStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePageRankStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutablePageRankStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(ImmutablePageRankStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutablePageRankStreamConfig.createUnmodifiableList(false, ImmutablePageRankStreamConfig.createSafeList(ImmutablePageRankStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutablePageRankStreamConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutablePageRankStreamConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutablePageRankStreamConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        double dampingFactor() {
            if (this.dampingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dampingFactorBuildStage == 0) {
                this.dampingFactorBuildStage = (byte)-1;
                this.dampingFactor = ImmutablePageRankStreamConfig.this.dampingFactorInitialize();
                this.dampingFactorBuildStage = 1;
            }
            return this.dampingFactor;
        }

        void dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.dampingFactorBuildStage = 1;
        }

        boolean cacheWeights() {
            if (this.cacheWeightsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheWeightsBuildStage == 0) {
                this.cacheWeightsBuildStage = (byte)-1;
                this.cacheWeights = ImmutablePageRankStreamConfig.this.cacheWeightsInitialize();
                this.cacheWeightsBuildStage = 1;
            }
            return this.cacheWeights;
        }

        void cacheWeights(boolean cacheWeights) {
            this.cacheWeights = cacheWeights;
            this.cacheWeightsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.dampingFactorBuildStage == -1) {
                attributes.add("dampingFactor");
            }
            if (this.cacheWeightsBuildStage == -1) {
                attributes.add("cacheWeights");
            }
            return "Cannot build PageRankStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

