/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.queue.BoundedLongLongPriorityQueue;
import org.neo4j.graphalgo.nodesim.SimilarityResult;

public class TopNList {
    private final BoundedLongLongPriorityQueue queue;

    static MemoryEstimation memoryEstimation(int topN) {
        return MemoryEstimations.builder(TopNList.class).add("queue", BoundedLongLongPriorityQueue.memoryEstimation((int)topN)).build();
    }

    public TopNList(int top) {
        int absTop = Math.abs(top);
        this.queue = top > 0 ? BoundedLongLongPriorityQueue.max((int)absTop) : BoundedLongLongPriorityQueue.min((int)absTop);
    }

    public void add(long node1, long node2, double similarity) {
        this.queue.offer(node1, node2, similarity);
    }

    public Stream<SimilarityResult> stream() {
        Iterable iterable = () -> new Iterator<SimilarityResult>(){
            PrimitiveIterator.OfLong elements1Iter;
            PrimitiveIterator.OfLong elements2Iter;
            PrimitiveIterator.OfDouble prioritiesIter;
            {
                this.elements1Iter = TopNList.this.queue.elements1().iterator();
                this.elements2Iter = TopNList.this.queue.elements2().iterator();
                this.prioritiesIter = TopNList.this.queue.priorities().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.elements1Iter.hasNext();
            }

            @Override
            public SimilarityResult next() {
                return new SimilarityResult(this.elements1Iter.nextLong(), this.elements2Iter.nextLong(), this.prioritiesIter.nextDouble());
            }
        };
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

