/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import java.util.Comparator;
import java.util.Objects;
import org.neo4j.graphalgo.core.loading.HugeGraphUtil;

public class SimilarityResult
implements Comparable<SimilarityResult>,
HugeGraphUtil.Relationship {
    static Comparator<SimilarityResult> ASCENDING = SimilarityResult::compareTo;
    static Comparator<SimilarityResult> DESCENDING = ASCENDING.reversed();
    public long node1;
    public long node2;
    public double similarity;

    public SimilarityResult(long node1, long node2, double similarity) {
        this.node1 = node1;
        this.node2 = node2;
        this.similarity = similarity;
    }

    public long sourceNodeId() {
        return this.node1;
    }

    public long targetNodeId() {
        return this.node2;
    }

    public double property() {
        return this.similarity;
    }

    public SimilarityResult reverse() {
        return new SimilarityResult(this.node2, this.node1, this.similarity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimilarityResult that = (SimilarityResult)o;
        return this.node1 == that.node1 && this.node2 == that.node2 && Double.compare(that.similarity, this.similarity) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.node1, this.node2, this.similarity);
    }

    public String toString() {
        return "SimilarityResult{node1=" + this.node1 + ", node2=" + this.node2 + ", similarity=" + this.similarity + '}';
    }

    @Override
    public int compareTo(SimilarityResult o) {
        return Double.compare(this.similarity, o.similarity);
    }
}

