/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapGraph;
import org.neo4j.graphalgo.core.Aggregation;
import org.neo4j.graphalgo.core.huge.AdjacencyList;
import org.neo4j.graphalgo.core.huge.AdjacencyOffsets;
import org.neo4j.graphalgo.core.huge.HugeGraph;
import org.neo4j.graphalgo.core.loading.HugeGraphUtil;
import org.neo4j.graphalgo.core.loading.IdMap;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.nodesim.SimilarityResult;

class SimilarityGraphBuilder {
    private final ExecutorService executorService;
    private final AllocationTracker tracker;
    private final IdMapGraph baseGraph;

    static MemoryEstimation memoryEstimation(int topK, int topN) {
        return MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            long maxNodesToCompare = Math.min(dimensions.maxRelCount(), dimensions.nodeCount());
            long maxNumberOfSimilarityResults = maxNodesToCompare * (maxNodesToCompare - 1L) / 2L;
            long newNodeCount = maxNodesToCompare;
            long newRelationshipCount = maxNumberOfSimilarityResults;
            if (topN > 0) {
                newRelationshipCount = Math.min(newRelationshipCount, (long)topN);
                newNodeCount = Math.min(maxNodesToCompare, newRelationshipCount * 2L);
            }
            int averageDegree = Math.toIntExact(newRelationshipCount / newNodeCount);
            if (topK > 0) {
                averageDegree = Math.min(Math.toIntExact(2L * newRelationshipCount / newNodeCount), topK);
            }
            return MemoryEstimations.builder(HugeGraph.class).add("adjacency list", AdjacencyList.compressedMemoryEstimation((long)averageDegree, (long)newNodeCount)).add("adjacency offsets", AdjacencyOffsets.memoryEstimation((int)concurrency, (long)newNodeCount)).build();
        });
    }

    SimilarityGraphBuilder(Graph baseGraph, ExecutorService executorService, AllocationTracker tracker) {
        this.executorService = executorService;
        this.tracker = tracker;
        if (!(baseGraph instanceof IdMapGraph)) {
            throw new IllegalArgumentException("Base graph must be an id map graph.");
        }
        this.baseGraph = (IdMapGraph)baseGraph;
    }

    Graph build(Stream<SimilarityResult> stream) {
        IdMap idMap = this.baseGraph.idMap();
        Orientation orientation = this.baseGraph.isUndirected() ? Orientation.UNDIRECTED : Orientation.NATURAL;
        HugeGraphUtil.RelationshipsBuilder relationshipsBuilder = HugeGraphUtil.createRelImporter((IdMap)idMap, (Orientation)orientation, (boolean)true, (Aggregation)Aggregation.NONE, (ExecutorService)this.executorService, (AllocationTracker)this.tracker);
        relationshipsBuilder.addFromInternal(stream);
        return HugeGraphUtil.create((IdMap)idMap, (HugeGraph.Relationships)relationshipsBuilder.build(), (AllocationTracker)this.tracker);
    }
}

