/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.nodesim.NodeSimilarityWriteConfig;

public final class NodeSimilarityWriteConfigImpl
implements NodeSimilarityWriteConfig {
    private final double similarityCutoff;
    private final int degreeCutoff;
    private final int topK;
    private final int topN;
    private final int bottomK;
    private final int bottomN;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final boolean sudo;
    private final String writeProperty;
    private final int writeConcurrency;
    private final String writeRelationshipType;

    public NodeSimilarityWriteConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.similarityCutoff = CypherMapWrapper.validateDoubleRange((String)"similarityCutoff", (double)config.getDouble("similarityCutoff", NodeSimilarityWriteConfig.super.similarityCutoff()), (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        this.degreeCutoff = CypherMapWrapper.validateIntegerRange((String)"degreeCutoff", (int)config.getInt("degreeCutoff", NodeSimilarityWriteConfig.super.degreeCutoff()), (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        this.topK = CypherMapWrapper.validateIntegerRange((String)"topK", (int)config.getInt("topK", NodeSimilarityWriteConfig.super.topK()), (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        this.topN = CypherMapWrapper.validateIntegerRange((String)"topN", (int)config.getInt("topN", NodeSimilarityWriteConfig.super.topN()), (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        this.bottomK = CypherMapWrapper.validateIntegerRange((String)"bottomK", (int)config.getInt("bottomK", NodeSimilarityWriteConfig.super.bottomK()), (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        this.bottomN = CypherMapWrapper.validateIntegerRange((String)"bottomN", (int)config.getInt("bottomN", NodeSimilarityWriteConfig.super.bottomN()), (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        this.concurrency = config.getInt("concurrency", NodeSimilarityWriteConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)NodeSimilarityWriteConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)NodeSimilarityWriteConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sudo = config.getBool("sudo", NodeSimilarityWriteConfig.super.sudo());
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)StringUtils.trimToNull((String)config.requireString("writeProperty")));
        this.writeConcurrency = config.getInt("writeConcurrency", NodeSimilarityWriteConfig.super.writeConcurrency());
        this.writeRelationshipType = (String)CypherMapWrapper.failOnNull((String)"writeRelationshipType", (Object)StringUtils.trimToNull((String)config.requireString("writeRelationshipType")));
        this.validate();
        this.validateConcurrency();
    }

    @Override
    public double similarityCutoff() {
        return this.similarityCutoff;
    }

    @Override
    public int degreeCutoff() {
        return this.degreeCutoff;
    }

    @Override
    public int topK() {
        return this.topK;
    }

    @Override
    public int topN() {
        return this.topN;
    }

    @Override
    public int bottomK() {
        return this.bottomK;
    }

    @Override
    public int bottomN() {
        return this.bottomN;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("similarityCutoff", "degreeCutoff", "topK", "topN", "bottomK", "bottomN", "concurrency", "relationshipTypes", "nodeLabels", "sudo", "writeProperty", "writeConcurrency", "writeRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("similarityCutoff", this.similarityCutoff());
        map.put("degreeCutoff", this.degreeCutoff());
        map.put("topK", this.topK());
        map.put("topN", this.topN());
        map.put("bottomK", this.bottomK());
        map.put("bottomN", this.bottomN());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeRelationshipType", this.writeRelationshipType());
        return map;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }
}

