/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.nodesim.NodeSimilarity;
import org.neo4j.graphalgo.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.graphalgo.nodesim.SimilarityGraphBuilder;
import org.neo4j.graphalgo.nodesim.TopKMap;
import org.neo4j.graphalgo.nodesim.TopNList;
import org.neo4j.logging.Log;

public class NodeSimilarityFactory<CONFIG extends NodeSimilarityBaseConfig>
extends AlgorithmFactory<NodeSimilarity, CONFIG> {
    public NodeSimilarity build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.relationshipCount(), "NodeSimilarity", configuration.concurrency());
        return new NodeSimilarity(graph, (NodeSimilarityBaseConfig)configuration, Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        int topN = Math.abs(config.normalizedN());
        int topK = Math.abs(config.normalizedK());
        MemoryEstimations.Builder builder = MemoryEstimations.builder(NodeSimilarity.class).perNode("node filter", nodeCount -> MemoryUsage.sizeOfLongArray((long)BitSet.bits2words((long)nodeCount))).add("vectors", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            int averageDegree = dimensions.nodeCount() == 0L ? 0 : Math.toIntExact(dimensions.maxRelCount() / dimensions.nodeCount());
            long averageVectorSize = MemoryUsage.sizeOfLongArray((long)averageDegree);
            return MemoryEstimations.builder(HugeObjectArray.class).perNode("array", nodeCount -> nodeCount * averageVectorSize).build();
        }));
        if (config.computeToGraph() && !config.hasTopK()) {
            builder.add("similarity graph", SimilarityGraphBuilder.memoryEstimation(topK, topN));
        }
        if (config.hasTopK()) {
            builder.add("topK map", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> TopKMap.memoryEstimation(dimensions.nodeCount(), topK)));
        }
        if (config.hasTopN()) {
            builder.add("topN list", TopNList.memoryEstimation(topN));
        }
        return builder.build();
    }
}

