/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import org.immutables.value.Value;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.config.AlgoBaseConfig;

public interface NodeSimilarityBaseConfig
extends AlgoBaseConfig {
    public static final String TOP_K_KEY = "topK";
    public static final int TOP_K_DEFAULT = 10;
    public static final String TOP_N_KEY = "topN";
    public static final int TOP_N_DEFAULT = 0;
    public static final String BOTTOM_K_KEY = "bottomK";
    public static final int BOTTOM_K_DEFAULT = 10;
    public static final String BOTTOM_N_KEY = "bottomN";
    public static final int BOTTOM_N_DEFAULT = 0;

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double similarityCutoff() {
        return 1.0E-42;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int degreeCutoff() {
        return 1;
    }

    @Value.Default
    @Configuration.Key(value="topK")
    @Configuration.IntegerRange(min=1)
    default public int topK() {
        return 10;
    }

    @Value.Default
    @Configuration.Key(value="topN")
    @Configuration.IntegerRange(min=0)
    default public int topN() {
        return 0;
    }

    @Value.Default
    @Configuration.Key(value="bottomK")
    @Configuration.IntegerRange(min=1)
    default public int bottomK() {
        return 10;
    }

    @Value.Default
    @Configuration.Key(value="bottomN")
    @Configuration.IntegerRange(min=0)
    default public int bottomN() {
        return 0;
    }

    @Configuration.Ignore
    @Value.Derived
    default public int normalizedK() {
        return this.bottomK() != 10 ? -this.bottomK() : this.topK();
    }

    @Configuration.Ignore
    @Value.Derived
    default public int normalizedN() {
        return this.bottomN() != 0 ? -this.bottomN() : this.topN();
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean isParallel() {
        return this.concurrency() > 1;
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean hasTopK() {
        return this.normalizedK() != 0;
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean hasTopN() {
        return this.normalizedN() != 0;
    }

    @Configuration.Ignore
    default public boolean computeToStream() {
        return false;
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean computeToGraph() {
        return !this.computeToStream();
    }

    @Value.Check
    default public void validate() {
        if (this.topK() != 10 && this.bottomK() != 10) {
            throw new IllegalArgumentException(String.format("Invalid parameter combination: %s combined with %s", TOP_K_KEY, BOTTOM_K_KEY));
        }
        if (this.topN() != 0 && this.bottomN() != 0) {
            throw new IllegalArgumentException(String.format("Invalid parameter combination: %s combined with %s", TOP_N_KEY, BOTTOM_N_KEY));
        }
    }
}

