/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.LongArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.Intersections;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.SetBitsIterable;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.nodesim.ImmutableNodeSimilarityResult;
import org.neo4j.graphalgo.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.graphalgo.nodesim.NodeSimilarityResult;
import org.neo4j.graphalgo.nodesim.SimilarityGraphBuilder;
import org.neo4j.graphalgo.nodesim.SimilarityGraphResult;
import org.neo4j.graphalgo.nodesim.SimilarityResult;
import org.neo4j.graphalgo.nodesim.TopKGraph;
import org.neo4j.graphalgo.nodesim.TopKMap;
import org.neo4j.graphalgo.nodesim.TopNList;

public class NodeSimilarity
extends Algorithm<NodeSimilarity, NodeSimilarityResult> {
    private final Graph graph;
    private final NodeSimilarityBaseConfig config;
    private final ExecutorService executorService;
    private final AllocationTracker tracker;
    private final BitSet nodeFilter;
    private HugeObjectArray<long[]> vectors;
    private long nodesToCompare;
    private static final ArraySizingStrategy ARRAY_SIZING_STRATEGY = (currentBufferLength, elementsCount, degree) -> elementsCount + degree;

    public NodeSimilarity(Graph graph, NodeSimilarityBaseConfig config, ExecutorService executorService, ProgressLogger progressLogger, AllocationTracker tracker) {
        this.graph = graph;
        this.config = config;
        this.executorService = executorService;
        this.progressLogger = progressLogger;
        this.tracker = tracker;
        this.nodeFilter = new BitSet(graph.nodeCount());
    }

    public NodeSimilarity me() {
        return this;
    }

    public void release() {
        this.graph.release();
    }

    public NodeSimilarityResult compute() {
        if (this.config.computeToStream()) {
            return ImmutableNodeSimilarityResult.of(Optional.of(this.computeToStream()), Optional.empty());
        }
        return ImmutableNodeSimilarityResult.of(Optional.empty(), Optional.of(this.computeToGraph()));
    }

    public Stream<SimilarityResult> computeToStream() {
        this.prepare();
        this.assertRunning();
        this.progressLogger.reset(this.calculateWorkload());
        this.progressLogger.logMessage("NodeSimilarity#computeToStream");
        if (this.config.hasTopN() && !this.config.hasTopK()) {
            return this.computeTopN();
        }
        return this.config.isParallel() ? this.computeParallel() : this.computeSimilarityResultStream();
    }

    public SimilarityGraphResult computeToGraph() {
        Object similarityGraph;
        boolean isTopKGraph = false;
        if (this.config.hasTopK() && !this.config.hasTopN()) {
            this.prepare();
            this.assertRunning();
            this.progressLogger.reset(this.calculateWorkload());
            this.progressLogger.logMessage("NodeSimilarity#computeToGraph");
            TopKMap topKMap = this.config.isParallel() ? this.computeTopKMapParallel() : this.computeTopKMap();
            isTopKGraph = true;
            similarityGraph = new TopKGraph(this.graph, topKMap);
        } else {
            Stream<SimilarityResult> similarities = this.computeToStream();
            similarityGraph = new SimilarityGraphBuilder(this.graph, this.executorService, this.tracker).build(similarities);
        }
        return new SimilarityGraphResult((Graph)similarityGraph, this.nodesToCompare, isTopKGraph);
    }

    private void prepare() {
        this.progressLogger.logMessage("Start :: NodeSimilarity#prepare");
        this.vectors = HugeObjectArray.newArray(long[].class, (long)this.graph.nodeCount(), (AllocationTracker)this.tracker);
        DegreeComputer degreeComputer = new DegreeComputer();
        VectorComputer vectorComputer = new VectorComputer();
        this.vectors.setAll(node -> {
            this.graph.forEachRelationship(node, (RelationshipConsumer)degreeComputer);
            int degree = degreeComputer.degree;
            degreeComputer.reset();
            vectorComputer.reset(degree);
            if (degree >= this.config.degreeCutoff()) {
                ++this.nodesToCompare;
                this.nodeFilter.set(node);
                this.graph.forEachRelationship(node, (RelationshipConsumer)vectorComputer);
                this.progressLogger.logProgress((long)this.graph.degree(node));
                return vectorComputer.targetIds.buffer;
            }
            this.progressLogger.logProgress((long)this.graph.degree(node));
            return null;
        });
        this.progressLogger.logMessage("Finish :: NodeSimilarity#prepare");
    }

    private Stream<SimilarityResult> computeSimilarityResultStream() {
        return this.config.hasTopK() && this.config.hasTopN() ? this.computeTopN(this.computeTopKMap()) : (this.config.hasTopK() ? this.computeTopKMap().stream() : this.computeAll());
    }

    private Stream<SimilarityResult> computeParallel() {
        return this.config.hasTopK() && this.config.hasTopN() ? this.computeTopN(this.computeTopKMapParallel()) : (this.config.hasTopK() ? this.computeTopKMapParallel().stream() : this.computeAllParallel());
    }

    private Stream<SimilarityResult> computeAll() {
        this.progressLogger.logMessage("NodeSimilarity#computeAll");
        return this.loggableAndTerminatableNodeStream().boxed().flatMap(node1 -> {
            long[] vector1 = (long[])this.vectors.get(node1.longValue());
            return this.nodeStream(node1 + 1L).mapToObj(node2 -> {
                double similarity = this.jaccard(vector1, (long[])this.vectors.get(node2));
                return Double.isNaN(similarity) ? null : new SimilarityResult((long)node1, node2, similarity);
            }).filter(Objects::nonNull);
        });
    }

    private Stream<SimilarityResult> computeAllParallel() {
        this.progressLogger.logMessage("NodeSimilarity#computeAllParallel");
        return (Stream)ParallelUtil.parallelStream((BaseStream)this.loggableAndTerminatableNodeStream(), (int)this.config.concurrency(), stream -> stream.boxed().flatMap(node1 -> {
            long[] vector1 = (long[])this.vectors.get(node1.longValue());
            return this.nodeStream(node1 + 1L).mapToObj(node2 -> {
                double similarity = this.jaccard(vector1, (long[])this.vectors.get(node2));
                return Double.isNaN(similarity) ? null : new SimilarityResult((long)node1, node2, similarity);
            }).filter(Objects::nonNull);
        }));
    }

    private TopKMap computeTopKMap() {
        this.progressLogger.logMessage("Start :: NodeSimilarity#computeTopKMap");
        Comparator<SimilarityResult> comparator = this.config.normalizedK() > 0 ? SimilarityResult.DESCENDING : SimilarityResult.ASCENDING;
        TopKMap topKMap = new TopKMap(this.vectors.size(), this.nodeFilter, Math.abs(this.config.normalizedK()), comparator, this.tracker);
        this.loggableAndTerminatableNodeStream().forEach(node1 -> {
            long[] vector1 = (long[])this.vectors.get(node1);
            this.nodeStream(node1 + 1L).forEach(node2 -> {
                double similarity = this.jaccard(vector1, (long[])this.vectors.get(node2));
                if (!Double.isNaN(similarity)) {
                    topKMap.put(node1, node2, similarity);
                    topKMap.put(node2, node1, similarity);
                }
            });
        });
        this.progressLogger.logMessage("Finish :: NodeSimilarity#computeTopKMap");
        return topKMap;
    }

    private TopKMap computeTopKMapParallel() {
        this.progressLogger.logMessage("Start :: NodeSimilarity#computeTopKMapParallel");
        Comparator<SimilarityResult> comparator = this.config.normalizedK() > 0 ? SimilarityResult.DESCENDING : SimilarityResult.ASCENDING;
        TopKMap topKMap = new TopKMap(this.vectors.size(), this.nodeFilter, Math.abs(this.config.normalizedK()), comparator, this.tracker);
        ParallelUtil.parallelStreamConsume((BaseStream)this.loggableAndTerminatableNodeStream(), (int)this.config.concurrency(), stream -> stream.forEach(node1 -> {
            long[] vector1 = (long[])this.vectors.get(node1);
            this.nodeStream().filter(node2 -> node1 != node2).forEach(node2 -> {
                double similarity = this.jaccard(vector1, (long[])this.vectors.get(node2));
                if (!Double.isNaN(similarity)) {
                    topKMap.put(node1, node2, similarity);
                }
            });
        }));
        this.progressLogger.logMessage("Finish :: NodeSimilarity#computeTopKMapParallel");
        return topKMap;
    }

    private Stream<SimilarityResult> computeTopN() {
        this.progressLogger.logMessage("Start :: NodeSimilarity#computeTopN");
        TopNList topNList = new TopNList(this.config.normalizedN());
        this.loggableAndTerminatableNodeStream().forEach(node1 -> {
            long[] vector1 = (long[])this.vectors.get(node1);
            this.nodeStream(node1 + 1L).forEach(node2 -> {
                double similarity = this.jaccard(vector1, (long[])this.vectors.get(node2));
                if (!Double.isNaN(similarity)) {
                    topNList.add(node1, node2, similarity);
                }
            });
        });
        this.progressLogger.logMessage("Finish :: NodeSimilarity#computeTopN");
        return topNList.stream();
    }

    private Stream<SimilarityResult> computeTopN(TopKMap topKMap) {
        this.progressLogger.logMessage("Start :: NodeSimilarity#computeTopN(TopKMap)");
        TopNList topNList = new TopNList(this.config.normalizedN());
        topKMap.forEach(topNList::add);
        this.progressLogger.logMessage("Finish :: NodeSimilarity#computeTopN(TopKMap)");
        return topNList.stream();
    }

    private double jaccard(long[] vector1, long[] vector2) {
        long intersection = Intersections.intersection3((long[])vector1, (long[])vector2);
        double union = (long)(vector1.length + vector2.length) - intersection;
        double similarity = union == 0.0 ? 0.0 : (double)intersection / union;
        this.getProgressLogger().logProgress();
        return similarity >= this.config.similarityCutoff() ? similarity : Double.NaN;
    }

    private LongStream nodeStream() {
        return this.nodeStream(0L);
    }

    private LongStream loggableAndTerminatableNodeStream() {
        return this.checkProgress(this.nodeStream());
    }

    private LongStream checkProgress(LongStream stream) {
        return stream.peek(node -> {
            if ((node & BatchingProgressLogger.MAXIMUM_LOG_INTERVAL) == 0L) {
                this.assertRunning();
            }
        });
    }

    private LongStream nodeStream(long offset) {
        return new SetBitsIterable(this.nodeFilter, offset).stream();
    }

    private long calculateWorkload() {
        long workload = this.nodesToCompare * this.nodesToCompare;
        if (this.config.concurrency() == 1) {
            workload /= 2L;
        }
        return workload;
    }

    private static final class DegreeComputer
    implements RelationshipConsumer {
        long lastTarget = -1L;
        int degree = 0;

        private DegreeComputer() {
        }

        public boolean accept(long source, long target) {
            if (source != target && this.lastTarget != target) {
                ++this.degree;
            }
            this.lastTarget = target;
            return true;
        }

        void reset() {
            this.lastTarget = -1L;
            this.degree = 0;
        }
    }

    private static final class VectorComputer
    implements RelationshipConsumer {
        long lastTarget = -1L;
        LongArrayList targetIds;

        private VectorComputer() {
        }

        public boolean accept(long source, long target) {
            if (source != target && this.lastTarget != target) {
                this.targetIds.add(target);
            }
            this.lastTarget = target;
            return true;
        }

        void reset(int degree) {
            this.lastTarget = -1L;
            this.targetIds = new LongArrayList(degree, ARRAY_SIZING_STRATEGY);
        }
    }
}

