/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.nodesim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.WriteConfig;
import org.neo4j.graphalgo.config.WritePropertyConfig;
import org.neo4j.graphalgo.config.WriteRelationshipConfig;
import org.neo4j.graphalgo.nodesim.NodeSimilarityBaseConfig;
import org.neo4j.graphalgo.nodesim.NodeSimilarityWriteConfig;

@Generated(from="NodeSimilarityWriteConfig", generator="Immutables")
public final class ImmutableNodeSimilarityWriteConfig
implements NodeSimilarityWriteConfig {
    private final String username;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    private final double similarityCutoff;
    private final int degreeCutoff;
    private final int topK;
    private final int topN;
    private final int bottomK;
    private final int bottomN;
    private final transient int normalizedK;
    private final transient int normalizedN;
    private final transient boolean isParallel;
    private final transient boolean hasTopK;
    private final transient boolean hasTopN;
    private final transient boolean computeToGraph;
    private final int writeConcurrency;
    private final String writeProperty;
    private final String writeRelationshipType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNodeSimilarityWriteConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityWriteConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityWriteConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.writeProperty = builder.writeProperty;
        this.writeRelationshipType = builder.writeRelationshipType;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.similarityCutoffIsSet()) {
            this.initShim.similarityCutoff(builder.similarityCutoff);
        }
        if (builder.degreeCutoffIsSet()) {
            this.initShim.degreeCutoff(builder.degreeCutoff);
        }
        if (builder.topKIsSet()) {
            this.initShim.topK(builder.topK);
        }
        if (builder.topNIsSet()) {
            this.initShim.topN(builder.topN);
        }
        if (builder.bottomKIsSet()) {
            this.initShim.bottomK(builder.bottomK);
        }
        if (builder.bottomNIsSet()) {
            this.initShim.bottomN(builder.bottomN);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableNodeSimilarityWriteConfig(String username, boolean sudo, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        this.initShim.username(username);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.similarityCutoff(similarityCutoff);
        this.initShim.degreeCutoff(degreeCutoff);
        this.initShim.topK(topK);
        this.initShim.topN(topN);
        this.initShim.bottomK(bottomK);
        this.initShim.bottomN(bottomN);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.writeRelationshipType = writeRelationshipType;
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.similarityCutoff = this.initShim.similarityCutoff();
        this.degreeCutoff = this.initShim.degreeCutoff();
        this.topK = this.initShim.topK();
        this.topN = this.initShim.topN();
        this.bottomK = this.initShim.bottomK();
        this.bottomN = this.initShim.bottomN();
        this.normalizedK = this.initShim.normalizedK();
        this.normalizedN = this.initShim.normalizedN();
        this.isParallel = this.initShim.isParallel();
        this.hasTopK = this.initShim.hasTopK();
        this.hasTopN = this.initShim.hasTopN();
        this.computeToGraph = this.initShim.computeToGraph();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return NodeSimilarityWriteConfig.super.username();
    }

    private boolean sudoInitialize() {
        return NodeSimilarityWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return NodeSimilarityWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeSimilarityWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return NodeSimilarityWriteConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return NodeSimilarityWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return NodeSimilarityWriteConfig.super.nodeLabels();
    }

    private double similarityCutoffInitialize() {
        return NodeSimilarityWriteConfig.super.similarityCutoff();
    }

    private int degreeCutoffInitialize() {
        return NodeSimilarityWriteConfig.super.degreeCutoff();
    }

    private int topKInitialize() {
        return NodeSimilarityWriteConfig.super.topK();
    }

    private int topNInitialize() {
        return NodeSimilarityWriteConfig.super.topN();
    }

    private int bottomKInitialize() {
        return NodeSimilarityWriteConfig.super.bottomK();
    }

    private int bottomNInitialize() {
        return NodeSimilarityWriteConfig.super.bottomN();
    }

    private int normalizedKInitialize() {
        return NodeSimilarityWriteConfig.super.normalizedK();
    }

    private int normalizedNInitialize() {
        return NodeSimilarityWriteConfig.super.normalizedN();
    }

    private boolean isParallelInitialize() {
        return NodeSimilarityWriteConfig.super.isParallel();
    }

    private boolean hasTopKInitialize() {
        return NodeSimilarityWriteConfig.super.hasTopK();
    }

    private boolean hasTopNInitialize() {
        return NodeSimilarityWriteConfig.super.hasTopN();
    }

    private boolean computeToGraphInitialize() {
        return NodeSimilarityWriteConfig.super.computeToGraph();
    }

    private int writeConcurrencyInitialize() {
        return NodeSimilarityWriteConfig.super.writeConcurrency();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Override
    public double similarityCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.similarityCutoff() : this.similarityCutoff;
    }

    @Override
    public int degreeCutoff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.degreeCutoff() : this.degreeCutoff;
    }

    @Override
    public int topK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topK() : this.topK;
    }

    @Override
    public int topN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topN() : this.topN;
    }

    @Override
    public int bottomK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomK() : this.bottomK;
    }

    @Override
    public int bottomN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bottomN() : this.bottomN;
    }

    @Override
    public int normalizedK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedK() : this.normalizedK;
    }

    @Override
    public int normalizedN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizedN() : this.normalizedN;
    }

    @Override
    public boolean isParallel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isParallel() : this.isParallel;
    }

    @Override
    public boolean hasTopK() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopK() : this.hasTopK;
    }

    @Override
    public boolean hasTopN() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTopN() : this.hasTopN;
    }

    @Override
    public boolean computeToGraph() {
        InitShim shim = this.initShim;
        return shim != null ? shim.computeToGraph() : this.computeToGraph;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public final ImmutableNodeSimilarityWriteConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, value, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(elements, true, false));
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withSimilarityCutoff(double value) {
        if (Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withDegreeCutoff(int value) {
        if (this.degreeCutoff == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, value, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withTopK(int value) {
        if (this.topK == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, value, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withTopN(int value) {
        if (this.topN == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, value, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withBottomK(int value) {
        if (this.bottomK == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, value, this.bottomN, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withBottomN(int value) {
        if (this.bottomN == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, value, this.writeConcurrency, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, value, this.writeProperty, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, newValue, this.writeRelationshipType));
    }

    public final ImmutableNodeSimilarityWriteConfig withWriteRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "writeRelationshipType");
        if (this.writeRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.similarityCutoff, this.degreeCutoff, this.topK, this.topN, this.bottomK, this.bottomN, this.writeConcurrency, this.writeProperty, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSimilarityWriteConfig && this.equalTo((ImmutableNodeSimilarityWriteConfig)another);
    }

    private boolean equalTo(ImmutableNodeSimilarityWriteConfig another) {
        return this.username.equals(another.username) && this.sudo == another.sudo && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && Double.doubleToLongBits(this.similarityCutoff) == Double.doubleToLongBits(another.similarityCutoff) && this.degreeCutoff == another.degreeCutoff && this.topK == another.topK && this.topN == another.topN && this.bottomK == another.bottomK && this.bottomN == another.bottomN && this.normalizedK == another.normalizedK && this.normalizedN == another.normalizedN && this.isParallel == another.isParallel && this.hasTopK == another.hasTopK && this.hasTopN == another.hasTopN && this.computeToGraph == another.computeToGraph && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && this.writeRelationshipType.equals(another.writeRelationshipType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + Double.hashCode(this.similarityCutoff);
        h += (h << 5) + this.degreeCutoff;
        h += (h << 5) + this.topK;
        h += (h << 5) + this.topN;
        h += (h << 5) + this.bottomK;
        h += (h << 5) + this.bottomN;
        h += (h << 5) + this.normalizedK;
        h += (h << 5) + this.normalizedN;
        h += (h << 5) + Boolean.hashCode(this.isParallel);
        h += (h << 5) + Boolean.hashCode(this.hasTopK);
        h += (h << 5) + Boolean.hashCode(this.hasTopN);
        h += (h << 5) + Boolean.hashCode(this.computeToGraph);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + this.writeRelationshipType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeSimilarityWriteConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        builder.append(", ");
        builder.append("similarityCutoff=").append(this.similarityCutoff);
        builder.append(", ");
        builder.append("degreeCutoff=").append(this.degreeCutoff);
        builder.append(", ");
        builder.append("topK=").append(this.topK);
        builder.append(", ");
        builder.append("topN=").append(this.topN);
        builder.append(", ");
        builder.append("bottomK=").append(this.bottomK);
        builder.append(", ");
        builder.append("bottomN=").append(this.bottomN);
        builder.append(", ");
        builder.append("normalizedK=").append(this.normalizedK);
        builder.append(", ");
        builder.append("normalizedN=").append(this.normalizedN);
        builder.append(", ");
        builder.append("isParallel=").append(this.isParallel);
        builder.append(", ");
        builder.append("hasTopK=").append(this.hasTopK);
        builder.append(", ");
        builder.append("hasTopN=").append(this.hasTopN);
        builder.append(", ");
        builder.append("computeToGraph=").append(this.computeToGraph);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        builder.append(", ");
        builder.append("writeRelationshipType=").append(this.writeRelationshipType);
        return builder.append("}").toString();
    }

    public static NodeSimilarityWriteConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableNodeSimilarityWriteConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, similarityCutoff, degreeCutoff, topK, topN, bottomK, bottomN, writeConcurrency, writeProperty, writeRelationshipType);
    }

    public static NodeSimilarityWriteConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, similarityCutoff, degreeCutoff, topK, topN, bottomK, bottomN, writeConcurrency, writeProperty, writeRelationshipType));
    }

    public static NodeSimilarityWriteConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, double similarityCutoff, int degreeCutoff, int topK, int topN, int bottomK, int bottomN, int writeConcurrency, String writeProperty, String writeRelationshipType) {
        return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, similarityCutoff, degreeCutoff, topK, topN, bottomK, bottomN, writeConcurrency, writeProperty, writeRelationshipType));
    }

    private static ImmutableNodeSimilarityWriteConfig validate(ImmutableNodeSimilarityWriteConfig instance) {
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static NodeSimilarityWriteConfig copyOf(NodeSimilarityWriteConfig instance) {
        if (instance instanceof ImmutableNodeSimilarityWriteConfig) {
            return (ImmutableNodeSimilarityWriteConfig)instance;
        }
        return ImmutableNodeSimilarityWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="NodeSimilarityWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long INIT_BIT_WRITE_RELATIONSHIP_TYPE = 2L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 4L;
        private static final long OPT_BIT_NODE_LABELS = 8L;
        private static final long OPT_BIT_SIMILARITY_CUTOFF = 16L;
        private static final long OPT_BIT_DEGREE_CUTOFF = 32L;
        private static final long OPT_BIT_TOP_K = 64L;
        private static final long OPT_BIT_TOP_N = 128L;
        private static final long OPT_BIT_BOTTOM_K = 256L;
        private static final long OPT_BIT_BOTTOM_N = 512L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 1024L;
        private long initBits = 3L;
        private long optBits;
        private String username;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private double similarityCutoff;
        private int degreeCutoff;
        private int topK;
        private int topN;
        private int bottomK;
        private int bottomN;
        private int writeConcurrency;
        private String writeProperty;
        private String writeRelationshipType;

        private Builder() {
        }

        public final Builder from(NodeSimilarityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeSimilarityWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            NodeSimilarityBaseConfig instance;
            if (object instanceof NodeSimilarityBaseConfig) {
                instance = (NodeSimilarityBaseConfig)object;
                this.topK(instance.topK());
                this.bottomK(instance.bottomK());
                this.degreeCutoff(instance.degreeCutoff());
                this.bottomN(instance.bottomN());
                this.topN(instance.topN());
                this.similarityCutoff(instance.similarityCutoff());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
                this.username(instance.username());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WriteRelationshipConfig) {
                instance = (WriteRelationshipConfig)object;
                this.writeRelationshipType(instance.writeRelationshipType());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder topK(int topK) {
            this.topK = topK;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder topN(int topN) {
            this.topN = topN;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder writeRelationshipType(String writeRelationshipType) {
            this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.username = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.similarityCutoff = 0.0;
            this.degreeCutoff = 0;
            this.topK = 0;
            this.topN = 0;
            this.bottomK = 0;
            this.bottomN = 0;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.writeRelationshipType = null;
            return this;
        }

        public NodeSimilarityWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNodeSimilarityWriteConfig.validate(new ImmutableNodeSimilarityWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean similarityCutoffIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean degreeCutoffIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean topKIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean topNIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean bottomKIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean bottomNIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("writeRelationshipType");
            }
            return "Cannot build NodeSimilarityWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NodeSimilarityWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte similarityCutoffBuildStage = 0;
        private double similarityCutoff;
        private byte degreeCutoffBuildStage = 0;
        private int degreeCutoff;
        private byte topKBuildStage = 0;
        private int topK;
        private byte topNBuildStage = 0;
        private int topN;
        private byte bottomKBuildStage = 0;
        private int bottomK;
        private byte bottomNBuildStage = 0;
        private int bottomN;
        private byte normalizedKBuildStage = 0;
        private int normalizedK;
        private byte normalizedNBuildStage = 0;
        private int normalizedN;
        private byte isParallelBuildStage = 0;
        private boolean isParallel;
        private byte hasTopKBuildStage = 0;
        private boolean hasTopK;
        private byte hasTopNBuildStage = 0;
        private boolean hasTopN;
        private byte computeToGraphBuildStage = 0;
        private boolean computeToGraph;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableNodeSimilarityWriteConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNodeSimilarityWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNodeSimilarityWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeSimilarityWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNodeSimilarityWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(ImmutableNodeSimilarityWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNodeSimilarityWriteConfig.createUnmodifiableList(false, ImmutableNodeSimilarityWriteConfig.createSafeList(ImmutableNodeSimilarityWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        double similarityCutoff() {
            if (this.similarityCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.similarityCutoffBuildStage == 0) {
                this.similarityCutoffBuildStage = (byte)-1;
                this.similarityCutoff = ImmutableNodeSimilarityWriteConfig.this.similarityCutoffInitialize();
                this.similarityCutoffBuildStage = 1;
            }
            return this.similarityCutoff;
        }

        void similarityCutoff(double similarityCutoff) {
            this.similarityCutoff = similarityCutoff;
            this.similarityCutoffBuildStage = 1;
        }

        int degreeCutoff() {
            if (this.degreeCutoffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.degreeCutoffBuildStage == 0) {
                this.degreeCutoffBuildStage = (byte)-1;
                this.degreeCutoff = ImmutableNodeSimilarityWriteConfig.this.degreeCutoffInitialize();
                this.degreeCutoffBuildStage = 1;
            }
            return this.degreeCutoff;
        }

        void degreeCutoff(int degreeCutoff) {
            this.degreeCutoff = degreeCutoff;
            this.degreeCutoffBuildStage = 1;
        }

        int topK() {
            if (this.topKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topKBuildStage == 0) {
                this.topKBuildStage = (byte)-1;
                this.topK = ImmutableNodeSimilarityWriteConfig.this.topKInitialize();
                this.topKBuildStage = 1;
            }
            return this.topK;
        }

        void topK(int topK) {
            this.topK = topK;
            this.topKBuildStage = 1;
        }

        int topN() {
            if (this.topNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topNBuildStage == 0) {
                this.topNBuildStage = (byte)-1;
                this.topN = ImmutableNodeSimilarityWriteConfig.this.topNInitialize();
                this.topNBuildStage = 1;
            }
            return this.topN;
        }

        void topN(int topN) {
            this.topN = topN;
            this.topNBuildStage = 1;
        }

        int bottomK() {
            if (this.bottomKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomKBuildStage == 0) {
                this.bottomKBuildStage = (byte)-1;
                this.bottomK = ImmutableNodeSimilarityWriteConfig.this.bottomKInitialize();
                this.bottomKBuildStage = 1;
            }
            return this.bottomK;
        }

        void bottomK(int bottomK) {
            this.bottomK = bottomK;
            this.bottomKBuildStage = 1;
        }

        int bottomN() {
            if (this.bottomNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bottomNBuildStage == 0) {
                this.bottomNBuildStage = (byte)-1;
                this.bottomN = ImmutableNodeSimilarityWriteConfig.this.bottomNInitialize();
                this.bottomNBuildStage = 1;
            }
            return this.bottomN;
        }

        void bottomN(int bottomN) {
            this.bottomN = bottomN;
            this.bottomNBuildStage = 1;
        }

        int normalizedK() {
            if (this.normalizedKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedKBuildStage == 0) {
                this.normalizedKBuildStage = (byte)-1;
                this.normalizedK = ImmutableNodeSimilarityWriteConfig.this.normalizedKInitialize();
                this.normalizedKBuildStage = 1;
            }
            return this.normalizedK;
        }

        int normalizedN() {
            if (this.normalizedNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedNBuildStage == 0) {
                this.normalizedNBuildStage = (byte)-1;
                this.normalizedN = ImmutableNodeSimilarityWriteConfig.this.normalizedNInitialize();
                this.normalizedNBuildStage = 1;
            }
            return this.normalizedN;
        }

        boolean isParallel() {
            if (this.isParallelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isParallelBuildStage == 0) {
                this.isParallelBuildStage = (byte)-1;
                this.isParallel = ImmutableNodeSimilarityWriteConfig.this.isParallelInitialize();
                this.isParallelBuildStage = 1;
            }
            return this.isParallel;
        }

        boolean hasTopK() {
            if (this.hasTopKBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopKBuildStage == 0) {
                this.hasTopKBuildStage = (byte)-1;
                this.hasTopK = ImmutableNodeSimilarityWriteConfig.this.hasTopKInitialize();
                this.hasTopKBuildStage = 1;
            }
            return this.hasTopK;
        }

        boolean hasTopN() {
            if (this.hasTopNBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTopNBuildStage == 0) {
                this.hasTopNBuildStage = (byte)-1;
                this.hasTopN = ImmutableNodeSimilarityWriteConfig.this.hasTopNInitialize();
                this.hasTopNBuildStage = 1;
            }
            return this.hasTopN;
        }

        boolean computeToGraph() {
            if (this.computeToGraphBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.computeToGraphBuildStage == 0) {
                this.computeToGraphBuildStage = (byte)-1;
                this.computeToGraph = ImmutableNodeSimilarityWriteConfig.this.computeToGraphInitialize();
                this.computeToGraphBuildStage = 1;
            }
            return this.computeToGraph;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableNodeSimilarityWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.similarityCutoffBuildStage == -1) {
                attributes.add("similarityCutoff");
            }
            if (this.degreeCutoffBuildStage == -1) {
                attributes.add("degreeCutoff");
            }
            if (this.topKBuildStage == -1) {
                attributes.add("topK");
            }
            if (this.topNBuildStage == -1) {
                attributes.add("topN");
            }
            if (this.bottomKBuildStage == -1) {
                attributes.add("bottomK");
            }
            if (this.bottomNBuildStage == -1) {
                attributes.add("bottomN");
            }
            if (this.normalizedKBuildStage == -1) {
                attributes.add("normalizedK");
            }
            if (this.normalizedNBuildStage == -1) {
                attributes.add("normalizedN");
            }
            if (this.isParallelBuildStage == -1) {
                attributes.add("isParallel");
            }
            if (this.hasTopKBuildStage == -1) {
                attributes.add("hasTopK");
            }
            if (this.hasTopNBuildStage == -1) {
                attributes.add("hasTopN");
            }
            if (this.computeToGraphBuildStage == -1) {
                attributes.add("computeToGraph");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build NodeSimilarityWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

