/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.louvain;

import java.util.Collections;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.ResolvedPropertyMappings;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.graphalgo.core.GraphDimensions;
import org.neo4j.graphalgo.core.ImmutableGraphDimensions;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.loading.NativeFactory;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryRange;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.louvain.Louvain;
import org.neo4j.graphalgo.louvain.LouvainBaseConfig;
import org.neo4j.logging.Log;

public class LouvainFactory<CONFIG extends LouvainBaseConfig>
extends AlgorithmFactory<Louvain, CONFIG> {
    public Louvain build(Graph graph, LouvainBaseConfig configuration, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, 1L, "Louvain", configuration.concurrency());
        return new Louvain(graph, configuration, Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(Louvain.class).add("modularityOptimization()", ModularityOptimizationFactory.MEMORY_ESTIMATION).rangePerGraphDimension("subGraph", (graphDimensions, concurrency) -> {
            ImmutableGraphDimensions.Builder dimensionsBuilder = ImmutableGraphDimensions.builder().from(graphDimensions);
            graphDimensions.relationshipProperties().stream().findFirst().map(prop -> dimensionsBuilder.relationshipProperties(ResolvedPropertyMappings.of(Collections.singletonList(prop))));
            dimensionsBuilder.nodePropertyTokens(graphDimensions.nodePropertyTokens());
            GraphDimensions sparseDimensions = dimensionsBuilder.build();
            long maxGraphSize = NativeFactory.getMemoryEstimation((GraphDimensions)sparseDimensions).estimate((GraphDimensions)sparseDimensions, (int)concurrency.intValue()).memoryUsage().max;
            return MemoryRange.of((long)1L, (long)maxGraphSize);
        }).rangePerNode("dendrograms", nodeCount -> MemoryRange.of((long)HugeLongArray.memoryEstimation((long)nodeCount), (long)(HugeLongArray.memoryEstimation((long)nodeCount) * (long)config.maxLevels()))).build();
    }
}

