/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.louvain;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.modularity.ImmutableModularityOptimizationStreamConfig;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimization;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationStreamConfig;
import org.neo4j.graphalgo.core.Aggregation;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.huge.HugeGraph;
import org.neo4j.graphalgo.core.loading.HugeGraphUtil;
import org.neo4j.graphalgo.core.loading.IdMap;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.louvain.LouvainBaseConfig;

public final class Louvain
extends Algorithm<Louvain, Louvain> {
    private final Graph rootGraph;
    private final LouvainBaseConfig config;
    private final NodeProperties seedingValues;
    private final ExecutorService executorService;
    private final AllocationTracker tracker;
    private HugeLongArray[] dendrograms;
    private double[] modularities;
    private int ranLevels;

    public Louvain(Graph graph, LouvainBaseConfig config, ExecutorService executorService, ProgressLogger progressLogger, AllocationTracker tracker) {
        this.config = config;
        this.rootGraph = graph;
        this.seedingValues = Optional.ofNullable(config.seedProperty()).map(arg_0 -> ((Graph)graph).nodeProperties(arg_0)).orElse(null);
        this.executorService = executorService;
        this.tracker = tracker;
        this.dendrograms = new HugeLongArray[config.maxLevels()];
        this.modularities = new double[config.maxLevels()];
        this.progressLogger = progressLogger;
    }

    public Louvain compute() {
        this.getProgressLogger().logMessage(":: Start");
        Graph workingGraph = this.rootGraph;
        NodeProperties nextSeedingValues = this.seedingValues;
        long oldNodeCount = this.rootGraph.nodeCount();
        this.ranLevels = 0;
        while (this.ranLevels < this.config.maxLevels()) {
            this.getProgressLogger().logMessage(String.format("Level %d :: Start", this.ranLevels + 1));
            this.assertRunning();
            ModularityOptimization modularityOptimization = this.runModularityOptimization(workingGraph, nextSeedingValues);
            modularityOptimization.release();
            this.modularities[this.ranLevels] = modularityOptimization.getModularity();
            this.dendrograms[this.ranLevels] = HugeLongArray.newArray((long)this.rootGraph.nodeCount(), (AllocationTracker)this.tracker);
            long maxCommunityId = this.buildDendrogram(workingGraph, this.ranLevels, modularityOptimization);
            workingGraph = this.summarizeGraph(workingGraph, modularityOptimization, maxCommunityId);
            nextSeedingValues = new OriginalIdNodeProperties(workingGraph);
            this.getProgressLogger().logMessage(String.format("Level %d :: Finished", this.ranLevels + 1));
            if (workingGraph.nodeCount() == oldNodeCount || workingGraph.nodeCount() == 1L || this.hasConverged()) {
                this.resizeResultArrays();
                this.getProgressLogger().logMessage(":: Finished");
                break;
            }
            oldNodeCount = workingGraph.nodeCount();
            ++this.ranLevels;
        }
        return this;
    }

    private void resizeResultArrays() {
        int numLevels = this.levels();
        HugeLongArray[] resizedDendrogram = new HugeLongArray[numLevels];
        double[] resizedModularities = new double[numLevels];
        if (numLevels < this.dendrograms.length) {
            System.arraycopy(this.dendrograms, 0, resizedDendrogram, 0, numLevels);
            System.arraycopy(this.modularities, 0, resizedModularities, 0, numLevels);
        }
        this.dendrograms = resizedDendrogram;
        this.modularities = resizedModularities;
    }

    private long buildDendrogram(Graph workingGraph, int level, ModularityOptimization modularityOptimization) {
        AtomicLong maxCommunityId = new AtomicLong(0L);
        ParallelUtil.parallelForEachNode((Graph)this.rootGraph, (int)this.config.concurrency(), nodeId -> {
            long prevId = level == 0 ? nodeId : workingGraph.toMappedNodeId(this.dendrograms[level - 1].get(nodeId));
            long communityId = modularityOptimization.getCommunityId(prevId);
            maxCommunityId.updateAndGet(currentMaxId -> Math.max(communityId, currentMaxId));
            this.dendrograms[level].set(nodeId, communityId);
        });
        return maxCommunityId.get();
    }

    private ModularityOptimization runModularityOptimization(Graph louvainGraph, NodeProperties seed) {
        ModularityOptimizationStreamConfig modularityOptimizationConfig = ImmutableModularityOptimizationStreamConfig.builder().maxIterations(10).tolerance(this.config.tolerance()).concurrency(this.config.concurrency()).batchSize(10000).build();
        ModularityOptimization modularityOptimization = (ModularityOptimization)new ModularityOptimizationFactory<ModularityOptimizationStreamConfig>().build(louvainGraph, modularityOptimizationConfig, seed, this.tracker, this.progressLogger.getLog()).withTerminationFlag(this.terminationFlag);
        modularityOptimization.compute();
        return modularityOptimization;
    }

    private Graph summarizeGraph(Graph workingGraph, ModularityOptimization modularityOptimization, long maxCommunityId) {
        HugeGraphUtil.IdMapBuilder idMapBuilder = HugeGraphUtil.idMapBuilder((long)maxCommunityId, (ExecutorService)this.executorService, (AllocationTracker)this.tracker);
        this.assertRunning();
        workingGraph.forEachNode(nodeId -> {
            idMapBuilder.addNode(modularityOptimization.getCommunityId(nodeId));
            return true;
        });
        this.assertRunning();
        Orientation orientation = this.rootGraph.isUndirected() ? Orientation.UNDIRECTED : Orientation.NATURAL;
        IdMap idMap = idMapBuilder.build();
        HugeGraphUtil.RelationshipsBuilder relationshipsBuilder = HugeGraphUtil.createRelImporter((IdMap)idMap, (Orientation)orientation, (boolean)true, (Aggregation)Aggregation.SUM, (ExecutorService)this.executorService, (AllocationTracker)this.tracker);
        workingGraph.forEachNode(nodeId -> {
            long communityId = modularityOptimization.getCommunityId(nodeId);
            workingGraph.forEachRelationship(nodeId, 1.0, (source, target, property) -> {
                relationshipsBuilder.add(communityId, modularityOptimization.getCommunityId(target), property);
                return true;
            });
            return true;
        });
        return HugeGraphUtil.create((IdMap)idMap, (HugeGraph.Relationships)relationshipsBuilder.build(), (AllocationTracker)this.tracker);
    }

    private boolean hasConverged() {
        if (this.ranLevels == 0) {
            return false;
        }
        double currentModularity = this.modularities[this.ranLevels];
        double previousModularity = this.modularities[this.ranLevels - 1];
        return !(currentModularity > previousModularity) || !(Math.abs(currentModularity - previousModularity) > this.config.tolerance());
    }

    public LouvainBaseConfig config() {
        return this.config;
    }

    public HugeLongArray[] dendrograms() {
        return this.dendrograms;
    }

    public HugeLongArray finalDendrogram() {
        return this.dendrograms[this.levels() - 1];
    }

    public long getCommunity(long nodeId) {
        return this.dendrograms[this.levels() - 1].get(nodeId);
    }

    public long[] getCommunities(long nodeId) {
        long[] communities = new long[this.dendrograms.length];
        for (int i = 0; i < this.dendrograms.length; ++i) {
            communities[i] = this.dendrograms[i].get(nodeId);
        }
        return communities;
    }

    public int levels() {
        return this.ranLevels == 0 ? 1 : this.ranLevels;
    }

    public double[] modularities() {
        return this.modularities;
    }

    public void release() {
        this.rootGraph.releaseTopology();
    }

    public Louvain me() {
        return this;
    }

    static class OriginalIdNodeProperties
    implements NodeProperties {
        private final Graph graph;

        public OriginalIdNodeProperties(Graph graph) {
            this.graph = graph;
        }

        public double nodeProperty(long nodeId) {
            return this.graph.toOriginalNodeId(nodeId);
        }
    }
}

