/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.louvain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.IterationsConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.SeedConfig;
import org.neo4j.graphalgo.config.ToleranceConfig;
import org.neo4j.graphalgo.louvain.LouvainBaseConfig;
import org.neo4j.graphalgo.louvain.LouvainStreamConfig;

@Generated(from="LouvainStreamConfig", generator="Immutables")
public final class ImmutableLouvainStreamConfig
implements LouvainStreamConfig {
    private final String username;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    @Nullable
    private final String seedProperty;
    @Nullable
    private final String relationshipWeightProperty;
    private final double tolerance;
    private final int maxIterations;
    private final int maxLevels;
    private final boolean includeIntermediateCommunities;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLouvainStreamConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.seedProperty(seedProperty);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.maxLevels(maxLevels);
        this.initShim.includeIntermediateCommunities(includeIntermediateCommunities);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.maxLevels = this.initShim.maxLevels();
        this.includeIntermediateCommunities = this.initShim.includeIntermediateCommunities();
        this.initShim = null;
    }

    private ImmutableLouvainStreamConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.seedProperty(seedProperty);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.maxLevels(maxLevels);
        this.initShim.includeIntermediateCommunities(includeIntermediateCommunities);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.maxLevels = this.initShim.maxLevels();
        this.includeIntermediateCommunities = this.initShim.includeIntermediateCommunities();
        this.initShim = null;
    }

    private ImmutableLouvainStreamConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableLouvainStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableLouvainStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.seedPropertyIsSet()) {
            this.initShim.seedProperty(builder.seedProperty);
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.maxLevelsIsSet()) {
            this.initShim.maxLevels(builder.maxLevels);
        }
        if (builder.includeIntermediateCommunitiesIsSet()) {
            this.initShim.includeIntermediateCommunities(builder.includeIntermediateCommunities);
        }
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.maxLevels = this.initShim.maxLevels();
        this.includeIntermediateCommunities = this.initShim.includeIntermediateCommunities();
        this.initShim = null;
    }

    private ImmutableLouvainStreamConfig(String username, boolean sudo, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        this.initShim.username(username);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.seedProperty(seedProperty);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.maxLevels(maxLevels);
        this.initShim.includeIntermediateCommunities(includeIntermediateCommunities);
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.maxLevels = this.initShim.maxLevels();
        this.includeIntermediateCommunities = this.initShim.includeIntermediateCommunities();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return LouvainStreamConfig.super.username();
    }

    private boolean sudoInitialize() {
        return LouvainStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return LouvainStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LouvainStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return LouvainStreamConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return LouvainStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return LouvainStreamConfig.super.nodeLabels();
    }

    @Nullable
    private String seedPropertyInitialize() {
        return LouvainStreamConfig.super.seedProperty();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return LouvainStreamConfig.super.relationshipWeightProperty();
    }

    private double toleranceInitialize() {
        return LouvainStreamConfig.super.tolerance();
    }

    private int maxIterationsInitialize() {
        return LouvainStreamConfig.super.maxIterations();
    }

    private int maxLevelsInitialize() {
        return LouvainStreamConfig.super.maxLevels();
    }

    private boolean includeIntermediateCommunitiesInitialize() {
        return LouvainStreamConfig.super.includeIntermediateCommunities();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Nullable
    public String seedProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedProperty() : this.seedProperty;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int maxLevels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxLevels() : this.maxLevels;
    }

    @Override
    public boolean includeIntermediateCommunities() {
        InitShim shim = this.initShim;
        return shim != null ? shim.includeIntermediateCommunities() : this.includeIntermediateCommunities;
    }

    public final ImmutableLouvainStreamConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, value, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(elements, true, false));
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(elements, true, false));
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withSeedProperty(@Nullable String value) {
        if (Objects.equals(this.seedProperty, value)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, value, this.tolerance, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, value, this.maxIterations, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, value, this.maxLevels, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withMaxLevels(int value) {
        if (this.maxLevels == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, value, this.includeIntermediateCommunities));
    }

    public final ImmutableLouvainStreamConfig withIncludeIntermediateCommunities(boolean value) {
        if (this.includeIntermediateCommunities == value) {
            return this;
        }
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedProperty, this.relationshipWeightProperty, this.tolerance, this.maxIterations, this.maxLevels, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLouvainStreamConfig && this.equalTo((ImmutableLouvainStreamConfig)another);
    }

    private boolean equalTo(ImmutableLouvainStreamConfig another) {
        return this.username.equals(another.username) && this.sudo == another.sudo && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && Objects.equals(this.seedProperty, another.seedProperty) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && this.maxIterations == another.maxIterations && this.maxLevels == another.maxLevels && this.includeIntermediateCommunities == another.includeIntermediateCommunities;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + Objects.hashCode(this.seedProperty);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.maxLevels;
        h += (h << 5) + Boolean.hashCode(this.includeIntermediateCommunities);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LouvainStreamConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        if (this.seedProperty != null) {
            builder.append(", ");
            builder.append("seedProperty=").append(this.seedProperty);
        }
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("tolerance=").append(this.tolerance);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("maxLevels=").append(this.maxLevels);
        builder.append(", ");
        builder.append("includeIntermediateCommunities=").append(this.includeIntermediateCommunities);
        return builder.append("}").toString();
    }

    public static LouvainStreamConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        return ImmutableLouvainStreamConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedProperty, relationshipWeightProperty, tolerance, maxIterations, maxLevels, includeIntermediateCommunities);
    }

    public static LouvainStreamConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedProperty, relationshipWeightProperty, tolerance, maxIterations, maxLevels, includeIntermediateCommunities));
    }

    public static LouvainStreamConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String seedProperty, @Nullable String relationshipWeightProperty, double tolerance, int maxIterations, int maxLevels, boolean includeIntermediateCommunities) {
        return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedProperty, relationshipWeightProperty, tolerance, maxIterations, maxLevels, includeIntermediateCommunities));
    }

    private static ImmutableLouvainStreamConfig validate(ImmutableLouvainStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static LouvainStreamConfig copyOf(LouvainStreamConfig instance) {
        if (instance instanceof ImmutableLouvainStreamConfig) {
            return (ImmutableLouvainStreamConfig)instance;
        }
        return ImmutableLouvainStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LouvainStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 4L;
        private static final long OPT_BIT_NODE_LABELS = 8L;
        private static final long OPT_BIT_SEED_PROPERTY = 16L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 32L;
        private static final long OPT_BIT_TOLERANCE = 64L;
        private static final long OPT_BIT_MAX_ITERATIONS = 128L;
        private static final long OPT_BIT_MAX_LEVELS = 256L;
        private static final long OPT_BIT_INCLUDE_INTERMEDIATE_COMMUNITIES = 512L;
        private long optBits;
        private String username;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private String seedProperty;
        private String relationshipWeightProperty;
        private double tolerance;
        private int maxIterations;
        private int maxLevels;
        private boolean includeIntermediateCommunities;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LouvainBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LouvainStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String seedPropertyValue;
            String relationshipWeightPropertyValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
                this.username(instance.username());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof LouvainBaseConfig) {
                instance = (LouvainBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.includeIntermediateCommunities(instance.includeIntermediateCommunities());
                this.maxLevels(instance.maxLevels());
                if ((bits & 2L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 2L;
                }
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof SeedConfig && (seedPropertyValue = (instance = (SeedConfig)object).seedProperty()) != null) {
                this.seedProperty(seedPropertyValue);
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder seedProperty(@Nullable String seedProperty) {
            this.seedProperty = seedProperty;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder maxLevels(int maxLevels) {
            this.maxLevels = maxLevels;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder includeIntermediateCommunities(boolean includeIntermediateCommunities) {
            this.includeIntermediateCommunities = includeIntermediateCommunities;
            this.optBits |= 0x200L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.username = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.seedProperty = null;
            this.relationshipWeightProperty = null;
            this.tolerance = 0.0;
            this.maxIterations = 0;
            this.maxLevels = 0;
            this.includeIntermediateCommunities = false;
            return this;
        }

        public LouvainStreamConfig build() {
            return ImmutableLouvainStreamConfig.validate(new ImmutableLouvainStreamConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean seedPropertyIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean maxLevelsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean includeIntermediateCommunitiesIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }
    }

    @Generated(from="LouvainStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte seedPropertyBuildStage = 0;
        private String seedProperty;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte maxLevelsBuildStage = 0;
        private int maxLevels;
        private byte includeIntermediateCommunitiesBuildStage = 0;
        private boolean includeIntermediateCommunities;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableLouvainStreamConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableLouvainStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableLouvainStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableLouvainStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableLouvainStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(ImmutableLouvainStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableLouvainStreamConfig.createUnmodifiableList(false, ImmutableLouvainStreamConfig.createSafeList(ImmutableLouvainStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String seedProperty() {
            if (this.seedPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedPropertyBuildStage == 0) {
                this.seedPropertyBuildStage = (byte)-1;
                this.seedProperty = ImmutableLouvainStreamConfig.this.seedPropertyInitialize();
                this.seedPropertyBuildStage = 1;
            }
            return this.seedProperty;
        }

        void seedProperty(String seedProperty) {
            this.seedProperty = seedProperty;
            this.seedPropertyBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableLouvainStreamConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutableLouvainStreamConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableLouvainStreamConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int maxLevels() {
            if (this.maxLevelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxLevelsBuildStage == 0) {
                this.maxLevelsBuildStage = (byte)-1;
                this.maxLevels = ImmutableLouvainStreamConfig.this.maxLevelsInitialize();
                this.maxLevelsBuildStage = 1;
            }
            return this.maxLevels;
        }

        void maxLevels(int maxLevels) {
            this.maxLevels = maxLevels;
            this.maxLevelsBuildStage = 1;
        }

        boolean includeIntermediateCommunities() {
            if (this.includeIntermediateCommunitiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.includeIntermediateCommunitiesBuildStage == 0) {
                this.includeIntermediateCommunitiesBuildStage = (byte)-1;
                this.includeIntermediateCommunities = ImmutableLouvainStreamConfig.this.includeIntermediateCommunitiesInitialize();
                this.includeIntermediateCommunitiesBuildStage = 1;
            }
            return this.includeIntermediateCommunities;
        }

        void includeIntermediateCommunities(boolean includeIntermediateCommunities) {
            this.includeIntermediateCommunities = includeIntermediateCommunities;
            this.includeIntermediateCommunitiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.seedPropertyBuildStage == -1) {
                attributes.add("seedProperty");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.maxLevelsBuildStage == -1) {
                attributes.add("maxLevels");
            }
            if (this.includeIntermediateCommunitiesBuildStage == -1) {
                attributes.add("includeIntermediateCommunities");
            }
            return "Cannot build LouvainStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

