/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.labelpropagation;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.labelpropagation.LabelPropagationStreamConfig;

public final class LabelPropagationStreamConfigImpl
implements LabelPropagationStreamConfig {
    private final int maxIterations;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final boolean sudo;
    @Nullable
    private final String seedProperty;
    @Nullable
    private final String relationshipWeightProperty;
    @Nullable
    private final String nodeWeightProperty;

    public LabelPropagationStreamConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.maxIterations = config.getInt("maxIterations", LabelPropagationStreamConfig.super.maxIterations());
        this.concurrency = config.getInt("concurrency", LabelPropagationStreamConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)LabelPropagationStreamConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)LabelPropagationStreamConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sudo = config.getBool("sudo", LabelPropagationStreamConfig.super.sudo());
        this.seedProperty = StringUtils.trimToNull((String)config.getString("seedProperty", LabelPropagationStreamConfig.super.seedProperty()));
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", LabelPropagationStreamConfig.super.relationshipWeightProperty()));
        this.nodeWeightProperty = StringUtils.trimToNull((String)config.getString("nodeWeightProperty", LabelPropagationStreamConfig.super.nodeWeightProperty()));
        this.validateConcurrency();
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxIterations", "concurrency", "relationshipTypes", "nodeLabels", "sudo", "seedProperty", "relationshipWeightProperty", "nodeWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxIterations", this.maxIterations());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("seedProperty", this.seedProperty());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("nodeWeightProperty", this.nodeWeightProperty());
        return map;
    }

    @Nullable
    public String seedProperty() {
        return this.seedProperty;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    @Nullable
    public String nodeWeightProperty() {
        return this.nodeWeightProperty;
    }
}

