/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.labelpropagation;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryRange;
import org.neo4j.graphalgo.core.utils.mem.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.labelpropagation.ComputeStep;
import org.neo4j.graphalgo.labelpropagation.ComputeStepConsumer;
import org.neo4j.graphalgo.labelpropagation.InitStep;
import org.neo4j.graphalgo.labelpropagation.LabelPropagation;
import org.neo4j.graphalgo.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.graphalgo.labelpropagation.StepRunner;
import org.neo4j.logging.Log;

public class LabelPropagationFactory<CONFIG extends LabelPropagationBaseConfig>
extends AlgorithmFactory<LabelPropagation, CONFIG> {
    private final LabelPropagationBaseConfig config;

    public LabelPropagationFactory(LabelPropagationBaseConfig config) {
        this.config = config;
    }

    public LabelPropagation build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.relationshipCount(), "LabelPropagation", configuration.concurrency());
        return new LabelPropagation(graph, this.config, Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(LabelPropagation.class).perNode("labels", HugeLongArray::memoryEstimation).perThread("votes", MemoryEstimations.builder().field("init step", InitStep.class).field("compute step", ComputeStep.class).field("step runner", StepRunner.class).field("compute step consumer", ComputeStepConsumer.class).field("votes container", LongDoubleScatterMap.class).rangePerNode("votes", nodeCount -> {
            long minBufferSize = MemoryUsage.sizeOfEmptyOpenHashContainer();
            long maxBufferSize = MemoryUsage.sizeOfOpenHashContainer((long)nodeCount);
            if (maxBufferSize < minBufferSize) {
                maxBufferSize = minBufferSize;
            }
            long min = MemoryUsage.sizeOfLongArray((long)minBufferSize) + MemoryUsage.sizeOfDoubleArray((long)minBufferSize);
            long max = MemoryUsage.sizeOfLongArray((long)maxBufferSize) + MemoryUsage.sizeOfDoubleArray((long)maxBufferSize);
            return MemoryRange.of((long)min, (long)max);
        }).build()).build();
    }
}

