/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.labelpropagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.loading.NullPropertyMap;
import org.neo4j.graphalgo.core.utils.LazyBatchCollection;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.labelpropagation.ComputeStep;
import org.neo4j.graphalgo.labelpropagation.InitStep;
import org.neo4j.graphalgo.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.graphalgo.labelpropagation.Step;
import org.neo4j.graphalgo.labelpropagation.StepRunner;

public class LabelPropagation
extends Algorithm<LabelPropagation, LabelPropagation> {
    public static final double DEFAULT_WEIGHT = 1.0;
    private final long nodeCount;
    private final AllocationTracker tracker;
    private final NodeProperties nodeProperties;
    private final NodeProperties nodeWeights;
    private final LabelPropagationBaseConfig config;
    private final ExecutorService executor;
    private Graph graph;
    private HugeLongArray labels;
    private final long maxLabelId;
    private long ranIterations;
    private boolean didConverge;
    private int batchSize;

    public LabelPropagation(Graph graph, LabelPropagationBaseConfig config, ExecutorService executor, ProgressLogger progressLogger, AllocationTracker tracker) {
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.config = config;
        this.executor = executor;
        this.tracker = tracker;
        this.batchSize = 10000;
        String seedPropertyKey = config.seedProperty();
        Object seedProperty = seedPropertyKey != null && graph.availableNodeProperties().contains(seedPropertyKey) ? graph.nodeProperties(seedPropertyKey) : new NullPropertyMap(0.0);
        this.nodeProperties = seedProperty;
        String nodeWeightPropertyKey = config.nodeWeightProperty();
        Object nodeWeightProperty = nodeWeightPropertyKey != null && graph.availableNodeProperties().contains(nodeWeightPropertyKey) ? graph.nodeProperties(nodeWeightPropertyKey) : new NullPropertyMap(1.0);
        this.nodeWeights = nodeWeightProperty;
        this.maxLabelId = this.nodeProperties.getMaxPropertyValue().orElse(-1L);
        this.progressLogger = progressLogger;
    }

    public LabelPropagation me() {
        return this;
    }

    public void release() {
        this.graph = null;
    }

    public long ranIterations() {
        return this.ranIterations;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public HugeLongArray labels() {
        return this.labels;
    }

    public LabelPropagation compute() {
        if ((long)this.config.maxIterations() <= 0L) {
            throw new IllegalArgumentException("Must iterate at least 1 time");
        }
        this.getProgressLogger().logMessage(":: Start");
        if (this.labels == null || this.labels.size() != this.nodeCount) {
            this.labels = HugeLongArray.newArray((long)this.nodeCount, (AllocationTracker)this.tracker);
        }
        this.ranIterations = 0L;
        this.didConverge = false;
        List<StepRunner> stepRunners = this.stepRunners();
        long currentIteration = 0L;
        while (currentIteration < (long)this.config.maxIterations()) {
            this.getProgressLogger().logMessage(String.format(":: Iteration %d :: Start", currentIteration + 1L));
            ParallelUtil.runWithConcurrency((int)this.config.concurrency(), stepRunners, (long)1L, (TimeUnit)TimeUnit.MICROSECONDS, (TerminationFlag)this.terminationFlag, (ExecutorService)this.executor);
            this.getProgressLogger().logMessage(String.format(":: Iteration %d :: Finished", ++currentIteration));
            this.getProgressLogger().reset(this.graph.relationshipCount());
        }
        long maxIteration = 0L;
        boolean converged = true;
        for (StepRunner stepRunner : stepRunners) {
            Step current = stepRunner.current;
            if (!(current instanceof ComputeStep)) continue;
            ComputeStep step = (ComputeStep)current;
            if (step.iteration > maxIteration) {
                maxIteration = step.iteration;
            }
            converged = converged && !step.didChange;
            step.release();
        }
        this.ranIterations = maxIteration;
        this.didConverge = converged;
        this.getProgressLogger().logMessage(":: Finished");
        return this.me();
    }

    private List<StepRunner> stepRunners() {
        long nodeCount = this.graph.nodeCount();
        long batchSize = ParallelUtil.adjustedBatchSize((long)nodeCount, (long)this.batchSize);
        Collection nodeBatches = LazyBatchCollection.of((long)nodeCount, (long)batchSize, (start, length) -> () -> PrimitiveLongCollections.range((long)start, (long)(start + length - 1L)));
        int threads = nodeBatches.size();
        ArrayList<StepRunner> tasks = new ArrayList<StepRunner>(threads);
        for (PrimitiveLongIterable iter : nodeBatches) {
            InitStep initStep = new InitStep(this.graph, this.nodeProperties, this.nodeWeights, iter, this.labels, this.getProgressLogger(), this.maxLabelId);
            StepRunner task = new StepRunner(initStep);
            tasks.add(task);
        }
        this.progressLogger.logMessage(":: Initialization :: Start");
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), tasks, (long)1L, (TimeUnit)TimeUnit.MICROSECONDS, (TerminationFlag)this.terminationFlag, (ExecutorService)this.executor);
        this.progressLogger.logMessage(":: Initialization :: Finished");
        this.progressLogger.reset(this.graph.relationshipCount());
        return tasks;
    }

    void withBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

