/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.labelpropagation;

import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.labelpropagation.ComputeStep;
import org.neo4j.graphalgo.labelpropagation.Step;

final class InitStep
implements Step {
    private final NodeProperties nodeProperties;
    private final HugeLongArray existingLabels;
    private final PrimitiveLongIterable nodes;
    private final Graph graph;
    private final NodeProperties nodeWeights;
    private final ProgressLogger progressLogger;
    private final long maxLabelId;

    InitStep(Graph graph, NodeProperties nodeProperties, NodeProperties nodeWeights, PrimitiveLongIterable nodes, HugeLongArray existingLabels, ProgressLogger progressLogger, long maxLabelId) {
        this.nodeProperties = nodeProperties;
        this.existingLabels = existingLabels;
        this.nodes = nodes;
        this.graph = graph;
        this.nodeWeights = nodeWeights;
        this.progressLogger = progressLogger;
        this.maxLabelId = maxLabelId;
    }

    @Override
    public final void run() {
        for (long nodeId : this.nodes) {
            double existingLabelValue = this.nodeProperties.nodeProperty(nodeId, Double.NaN);
            long existingLabel = Double.isNaN(existingLabelValue) ? this.maxLabelId + this.graph.toOriginalNodeId(nodeId) + 1L : (long)existingLabelValue;
            this.existingLabels.set(nodeId, existingLabel);
            this.progressLogger.logProgress((long)this.graph.degree(nodeId));
        }
    }

    @Override
    public Step next() {
        return new ComputeStep(this.graph, this.nodeWeights, this.progressLogger, this.existingLabels, this.nodes);
    }
}

