/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.labelpropagation;

import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.api.RelationshipWithPropertyConsumer;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.labelpropagation.ComputeStepConsumer;
import org.neo4j.graphalgo.labelpropagation.Step;

final class ComputeStep
implements Step {
    private final RelationshipIterator localRelationshipIterator;
    private final HugeLongArray existingLabels;
    private final PrimitiveLongIterable nodes;
    private final ProgressLogger progressLogger;
    private final ComputeStepConsumer consumer;
    private final Graph graph;
    boolean didChange = true;
    long iteration = 0L;

    ComputeStep(Graph graph, NodeProperties nodeWeights, ProgressLogger progressLogger, HugeLongArray existingLabels, PrimitiveLongIterable nodes) {
        this.existingLabels = existingLabels;
        this.progressLogger = progressLogger;
        this.graph = graph;
        this.localRelationshipIterator = graph.concurrentCopy();
        this.nodes = nodes;
        this.consumer = new ComputeStepConsumer(nodeWeights, existingLabels);
    }

    @Override
    public Step next() {
        return this;
    }

    @Override
    public void run() {
        if (this.didChange) {
            ++this.iteration;
            this.didChange = this.iterateAll(this.nodes.iterator());
            if (!this.didChange) {
                this.release();
            }
        }
    }

    private boolean iterateAll(PrimitiveLongIterator nodeIds) {
        boolean didChange = false;
        while (nodeIds.hasNext()) {
            long nodeId = nodeIds.next();
            didChange = this.compute(nodeId, didChange);
            this.progressLogger.logProgress((long)this.graph.degree(nodeId));
        }
        return didChange;
    }

    private boolean compute(long nodeId, boolean didChange) {
        this.consumer.clearVotes();
        long label = this.existingLabels.get(nodeId);
        this.localRelationshipIterator.forEachRelationship(nodeId, 1.0, (RelationshipWithPropertyConsumer)this.consumer);
        long newLabel = this.consumer.tallyVotes(label);
        if (newLabel != label) {
            this.existingLabels.set(nodeId, newLabel);
            return true;
        }
        return didChange;
    }

    void release() {
        this.consumer.release();
    }
}

