/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.pregel.examples;

import java.util.Queue;
import org.neo4j.graphalgo.beta.pregel.PregelComputation;
import org.neo4j.graphalgo.beta.pregel.PregelContext;

public class SingleSourceShortestPathPregel
implements PregelComputation {
    private final long startNode;

    public SingleSourceShortestPathPregel(long startNode) {
        this.startNode = startNode;
    }

    @Override
    public void compute(PregelContext pregel, long nodeId, Queue<Double> messages) {
        if (pregel.isInitialSuperStep()) {
            if (nodeId == this.startNode) {
                pregel.setNodeValue(nodeId, 0.0);
                pregel.sendMessages(nodeId, 1.0);
            } else {
                pregel.setNodeValue(nodeId, 9.223372036854776E18);
            }
        } else {
            long newDistance = (long)pregel.getNodeValue(nodeId);
            boolean hasChanged = false;
            if (messages != null) {
                Double message;
                while ((message = messages.poll()) != null) {
                    if (!(message < (double)newDistance)) continue;
                    newDistance = message.longValue();
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                pregel.setNodeValue(nodeId, newDistance);
                pregel.sendMessages(nodeId, newDistance + 1L);
            }
            pregel.voteToHalt(nodeId);
        }
    }
}

