/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.pregel.examples;

import java.util.Queue;
import org.neo4j.graphalgo.beta.pregel.PregelComputation;
import org.neo4j.graphalgo.beta.pregel.PregelContext;

public class PageRankPregel
implements PregelComputation {
    private final long nodeCount;
    private final double jumpProbability;
    private final double dampingFactor;

    public PageRankPregel(long nodeCount, double dampingFactor) {
        this.nodeCount = nodeCount;
        this.jumpProbability = 1.0 - dampingFactor;
        this.dampingFactor = dampingFactor;
    }

    @Override
    public void compute(PregelContext pregel, long nodeId, Queue<Double> messages) {
        double newRank = pregel.getNodeValue(nodeId);
        if (!pregel.isInitialSuperStep()) {
            double sum = 0.0;
            if (messages != null) {
                Double nextMessage;
                while (!(nextMessage = messages.poll()).isNaN()) {
                    sum += nextMessage.doubleValue();
                }
            }
            newRank = this.jumpProbability / (double)this.nodeCount + this.dampingFactor * sum;
        }
        pregel.setNodeValue(nodeId, newRank);
        pregel.sendMessages(nodeId, newRank / (double)pregel.getDegree(nodeId));
    }
}

