/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.pregel.examples;

import java.util.Arrays;
import java.util.Queue;
import org.neo4j.graphalgo.beta.pregel.PregelComputation;
import org.neo4j.graphalgo.beta.pregel.PregelContext;

public class LabelPropagationPregel
implements PregelComputation {
    @Override
    public void compute(PregelContext pregel, long nodeId, Queue<Double> messages) {
        if (pregel.isInitialSuperStep()) {
            pregel.setNodeValue(nodeId, nodeId);
            pregel.sendMessages(nodeId, nodeId);
        } else if (messages != null) {
            Double nextMessage;
            long oldValue;
            long newValue = oldValue = (long)pregel.getNodeValue(nodeId);
            long[] buffer = new long[pregel.getDegree(nodeId)];
            int messageCount = 0;
            while (!(nextMessage = messages.poll()).isNaN()) {
                buffer[messageCount++] = nextMessage.longValue();
            }
            int maxOccurences = 1;
            if (messageCount > 1) {
                Arrays.sort(buffer, 0, messageCount);
                int currentOccurences = 1;
                for (int i = 1; i < messageCount; ++i) {
                    if (buffer[i] == buffer[i - 1]) {
                        if (++currentOccurences <= maxOccurences) continue;
                        maxOccurences = currentOccurences;
                        newValue = buffer[i];
                        continue;
                    }
                    currentOccurences = 1;
                }
            }
            if (maxOccurences == 1) {
                newValue = Math.min(oldValue, buffer[0]);
            }
            if (newValue != oldValue) {
                pregel.setNodeValue(nodeId, newValue);
                pregel.sendMessages(nodeId, newValue);
            }
        }
        pregel.voteToHalt(nodeId);
    }
}

