/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.pregel.examples;

import java.util.Queue;
import org.neo4j.graphalgo.beta.pregel.PregelComputation;
import org.neo4j.graphalgo.beta.pregel.PregelContext;

public class ConnectedComponentsPregel
implements PregelComputation {
    @Override
    public void compute(PregelContext pregel, long nodeId, Queue<Double> messages) {
        if (pregel.isInitialSuperStep()) {
            double currentValue = pregel.getNodeValue(nodeId);
            if (Double.compare(currentValue, pregel.getInitialNodeValue()) == 0) {
                pregel.sendMessages(nodeId, nodeId);
                pregel.setNodeValue(nodeId, nodeId);
            } else {
                pregel.sendMessages(nodeId, currentValue);
            }
        } else {
            long newComponentId = (long)pregel.getNodeValue(nodeId);
            boolean hasChanged = false;
            if (messages != null) {
                Double message;
                while ((message = messages.poll()) != null) {
                    if (!(message < (double)newComponentId)) continue;
                    newComponentId = message.longValue();
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                pregel.setNodeValue(nodeId, newComponentId);
                pregel.sendMessages(nodeId, newComponentId);
            }
            pregel.voteToHalt(nodeId);
        }
    }
}

