/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.pregel;

import org.neo4j.graphalgo.beta.pregel.Pregel;
import org.neo4j.graphalgo.beta.pregel.PregelConfig;

public final class PregelContext {
    private final Pregel.ComputeStep computeStep;
    private final PregelConfig config;

    PregelContext(Pregel.ComputeStep computeStep, PregelConfig config) {
        this.computeStep = computeStep;
        this.config = config;
    }

    public void voteToHalt(long nodeId) {
        this.computeStep.voteToHalt(nodeId);
    }

    public boolean isInitialSuperStep() {
        return this.getSuperstep() == 0;
    }

    public int getSuperstep() {
        return this.computeStep.getIteration();
    }

    public double getNodeValue(long nodeId) {
        return this.computeStep.getNodeValue(nodeId);
    }

    public void setNodeValue(long nodeId, double value) {
        this.computeStep.setNodeValue(nodeId, value);
    }

    public void sendMessages(long nodeId, double message) {
        this.computeStep.sendMessages(nodeId, message);
    }

    public int getDegree(long nodeId) {
        return this.computeStep.getDegree(nodeId);
    }

    public double getInitialNodeValue() {
        return this.config.getInitialNodeValue();
    }
}

