/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.modularity;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;

final class ModularityOptimizationTask
implements Runnable {
    private final Graph graph;
    private final RelationshipIterator localGraph;
    private final long batchStart;
    private final long batchEnd;
    private final long color;
    private final double totalNodeWeight;
    private final HugeLongArray colors;
    private final ProgressLogger progressLogger;
    private final HugeLongArray currentCommunities;
    private final HugeLongArray nextCommunities;
    private final HugeDoubleArray cumulativeNodeWeights;
    private final HugeDoubleArray nodeCommunityInfluences;
    private final HugeAtomicDoubleArray communityWeights;
    private final HugeAtomicDoubleArray communityWeightUpdates;

    ModularityOptimizationTask(Graph graph, long batchStart, long batchEnd, long color, double totalNodeWeight, HugeLongArray colors, HugeLongArray currentCommunities, HugeLongArray nextCommunities, HugeDoubleArray cumulativeNodeWeights, HugeDoubleArray nodeCommunityInfluences, HugeAtomicDoubleArray communityWeights, HugeAtomicDoubleArray communityWeightUpdates, ProgressLogger progressLogger) {
        this.graph = graph;
        this.batchStart = batchStart;
        this.batchEnd = batchEnd;
        this.color = color;
        this.localGraph = graph.concurrentCopy();
        this.currentCommunities = currentCommunities;
        this.nextCommunities = nextCommunities;
        this.communityWeights = communityWeights;
        this.communityWeightUpdates = communityWeightUpdates;
        this.totalNodeWeight = totalNodeWeight;
        this.cumulativeNodeWeights = cumulativeNodeWeights;
        this.nodeCommunityInfluences = nodeCommunityInfluences;
        this.colors = colors;
        this.progressLogger = progressLogger;
    }

    @Override
    public void run() {
        LongDoubleHashMap reuseCommunityInfluences = new LongDoubleHashMap(50);
        for (long nodeId = this.batchStart; nodeId < this.batchEnd; ++nodeId) {
            LongDoubleHashMap communityInfluences;
            if (this.colors.get(nodeId) != this.color) continue;
            long currentCommunity = this.currentCommunities.get(nodeId);
            int degree = this.graph.degree(nodeId);
            if (degree < 50) {
                reuseCommunityInfluences.clear();
                communityInfluences = reuseCommunityInfluences;
            } else {
                communityInfluences = new LongDoubleHashMap(degree);
            }
            MutableDouble selfWeight = new MutableDouble(0.0);
            this.localGraph.forEachRelationship(nodeId, 1.0, (arg_0, arg_1, arg_2) -> this.lambda$run$0(selfWeight, (LongDoubleMap)communityInfluences, arg_0, arg_1, arg_2));
            long nextCommunity = currentCommunity;
            double maxGain = 0.0;
            double eix = communityInfluences.get(currentCommunity) - selfWeight.doubleValue();
            double cumulativeNodeWeight = this.cumulativeNodeWeights.get(nodeId);
            double ax = this.communityWeights.get(currentCommunity) - cumulativeNodeWeight;
            for (LongDoubleCursor cursor : communityInfluences) {
                double ay;
                double eiy;
                double currentGain;
                long communityCandidate = cursor.key;
                if (currentCommunity == communityCandidate || !((currentGain = ((eiy = cursor.value) - eix) / this.totalNodeWeight + (2.0 * cumulativeNodeWeight * ax - 2.0 * cumulativeNodeWeight * (ay = this.communityWeights.get(communityCandidate))) / Math.pow(2.0 * this.totalNodeWeight, 2.0)) > maxGain) && (currentGain != maxGain || currentGain == 0.0 || nextCommunity <= communityCandidate)) continue;
                maxGain = currentGain;
                nextCommunity = communityCandidate;
            }
            this.nodeCommunityInfluences.set(nodeId, communityInfluences.get(nextCommunity));
            this.nextCommunities.set(nodeId, nextCommunity);
            this.communityWeightUpdates.update(currentCommunity, agg -> agg - cumulativeNodeWeight);
            this.communityWeightUpdates.update(nextCommunity, agg -> agg + cumulativeNodeWeight);
            this.progressLogger.logProgress((long)this.graph.degree(nodeId));
        }
    }

    private /* synthetic */ boolean lambda$run$0(MutableDouble selfWeight, LongDoubleMap communityInfluences, long s, long t, double w) {
        if (s == t) {
            selfWeight.add(w);
        }
        long targetCommunity = this.currentCommunities.get(t);
        communityInfluences.addTo(targetCommunity, w);
        return true;
    }
}

