/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.modularity;

import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimization;
import org.neo4j.graphalgo.beta.modularity.ModularityOptimizationConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryRange;
import org.neo4j.graphalgo.core.utils.mem.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.logging.Log;

public class ModularityOptimizationFactory<T extends ModularityOptimizationConfig>
extends AlgorithmFactory<ModularityOptimization, T> {
    public static final MemoryEstimation MEMORY_ESTIMATION = MemoryEstimations.builder(ModularityOptimization.class).perNode("currentCommunities", HugeLongArray::memoryEstimation).perNode("nextCommunities", HugeLongArray::memoryEstimation).perNode("cumulativeNodeWeights", HugeDoubleArray::memoryEstimation).perNode("nodeCommunityInfluences", HugeDoubleArray::memoryEstimation).perNode("communityWeights", HugeAtomicDoubleArray::memoryEstimation).perNode("colorsUsed", MemoryUsage::sizeOfBitset).perNode("colors", HugeLongArray::memoryEstimation).rangePerNode("reversedSeedCommunityMapping", nodeCount -> MemoryRange.of((long)0L, (long)HugeLongArray.memoryEstimation((long)nodeCount))).perNode("communityWeightUpdates", HugeAtomicDoubleArray::memoryEstimation).perThread("ModularityOptimizationTask", MemoryEstimations.builder().rangePerNode("communityInfluences", nodeCount -> MemoryRange.of((long)MemoryUsage.sizeOfLongDoubleHashMap((long)50L), (long)MemoryUsage.sizeOfLongDoubleHashMap((long)Math.max(50L, nodeCount)))).build()).build();

    public MemoryEstimation memoryEstimation(T configuration) {
        return MEMORY_ESTIMATION;
    }

    public ModularityOptimization build(Graph graph, T configuration, AllocationTracker tracker, Log log) {
        return this.build(graph, configuration, configuration.seedProperty() != null ? graph.nodeProperties(configuration.seedProperty()) : null, tracker, log);
    }

    public ModularityOptimization build(Graph graph, T configuration, NodeProperties seed, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.relationshipCount(), "ModularityOptimization", configuration.concurrency());
        return new ModularityOptimization(graph, configuration.maxIterations(), configuration.tolerance(), seed, configuration.concurrency(), configuration.batchSize(), Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }
}

