/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;

final class ValidationStep
implements Runnable {
    private final RelationshipIterator graph;
    private final HugeLongArray colors;
    private final BitSet currentNodesToColor;
    private final BitSet nextNodesToColor;
    private final long offset;
    private final long batchEnd;
    private final ProgressLogger progressLogger;

    ValidationStep(RelationshipIterator graph, HugeLongArray colors, BitSet currentNodesToColor, BitSet nextNodesToColor, long nodeCount, long offset, long batchSize, ProgressLogger progressLogger) {
        this.graph = graph;
        this.colors = colors;
        this.currentNodesToColor = currentNodesToColor;
        this.nextNodesToColor = nextNodesToColor;
        this.offset = offset;
        this.batchEnd = Math.min(offset + batchSize, nodeCount);
        this.progressLogger = progressLogger;
    }

    @Override
    public void run() {
        for (long nodeId = this.offset; nodeId < this.batchEnd; ++nodeId) {
            if (!this.currentNodesToColor.get(nodeId)) continue;
            this.graph.forEachRelationship(nodeId, (source, target) -> {
                if (source != target && this.colors.get(source) == this.colors.get(target) && !this.nextNodesToColor.get(target)) {
                    this.nextNodesToColor.set(source);
                    return false;
                }
                return true;
            });
            this.progressLogger.logProgress();
        }
    }
}

