/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringMutateConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;

public final class K1ColoringMutateConfigImpl
implements K1ColoringMutateConfig {
    private final int maxIterations;
    private final int batchSize;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final boolean sudo;
    private final String mutateProperty;

    public K1ColoringMutateConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.maxIterations = config.getInt("maxIterations", K1ColoringMutateConfig.super.maxIterations());
        this.batchSize = config.getInt("batchSize", K1ColoringMutateConfig.super.batchSize());
        this.concurrency = config.getInt("concurrency", K1ColoringMutateConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)K1ColoringMutateConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)K1ColoringMutateConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sudo = config.getBool("sudo", K1ColoringMutateConfig.super.sudo());
        this.mutateProperty = (String)CypherMapWrapper.failOnNull((String)"mutateProperty", (Object)StringUtils.trimToNull((String)config.requireString("mutateProperty")));
        this.validateConcurrency();
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxIterations", "batchSize", "concurrency", "relationshipTypes", "nodeLabels", "sudo", "mutateProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxIterations", this.maxIterations());
        map.put("batchSize", this.batchSize());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("mutateProperty", this.mutateProperty());
        return map;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }
}

