/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.k1coloring.ColoringStep;
import org.neo4j.graphalgo.beta.k1coloring.K1Coloring;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimations;
import org.neo4j.graphalgo.core.utils.mem.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.logging.Log;

public class K1ColoringFactory<T extends K1ColoringConfig>
extends AlgorithmFactory<K1Coloring, T> {
    public K1Coloring build(Graph graph, T configuration, AllocationTracker tracker, Log log) {
        BatchingProgressLogger progressLogger = new BatchingProgressLogger(log, graph.nodeCount() * 2L, "K1Coloring", configuration.concurrency());
        return new K1Coloring(graph, configuration.maxIterations(), configuration.batchSize(), configuration.concurrency(), Pools.DEFAULT, (ProgressLogger)progressLogger, tracker);
    }

    public MemoryEstimation memoryEstimation(T config) {
        return MemoryEstimations.builder(K1Coloring.class).perNode("colors", HugeLongArray::memoryEstimation).perNode("nodesToColor", MemoryUsage::sizeOfBitset).perThread("coloring", MemoryEstimations.builder().field("coloringStep", ColoringStep.class).perNode("forbiddenColors", MemoryUsage::sizeOfBitset).build()).build();
    }
}

