/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.api.Degrees;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.k1coloring.ColoringStep;
import org.neo4j.graphalgo.beta.k1coloring.ValidationStep;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.utils.BitUtil;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.SetBitsIterable;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.core.utils.partition.PartitionUtils;

public class K1Coloring
extends Algorithm<K1Coloring, HugeLongArray> {
    private final Graph graph;
    private final long nodeCount;
    private final ExecutorService executor;
    private final AllocationTracker tracker;
    private final int minBatchSize;
    private final int concurrency;
    private final long maxIterations;
    private BitSet nodesToColor;
    private HugeLongArray colors;
    private long ranIterations;
    private boolean didConverge;
    private BitSet usedColors;

    public K1Coloring(Graph graph, long maxIterations, int minBatchSize, int concurrency, ExecutorService executor, ProgressLogger progressLogger, AllocationTracker tracker) {
        this.graph = graph;
        this.minBatchSize = minBatchSize;
        this.concurrency = concurrency;
        this.executor = executor;
        this.progressLogger = progressLogger;
        this.tracker = tracker;
        this.nodeCount = graph.nodeCount();
        this.maxIterations = maxIterations;
        this.nodesToColor = new BitSet(this.nodeCount);
        if (maxIterations <= 0L) {
            throw new IllegalArgumentException("Must iterate at least 1 time");
        }
    }

    public K1Coloring me() {
        return this;
    }

    public void release() {
        this.graph.release();
        this.nodesToColor = null;
    }

    public long ranIterations() {
        return this.ranIterations;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public BitSet usedColors() {
        if (this.usedColors == null) {
            this.usedColors = new BitSet(this.nodeCount);
            this.graph.forEachNode(nodeId -> {
                this.usedColors.set(this.colors.get(nodeId));
                return true;
            });
        }
        return this.usedColors;
    }

    public HugeLongArray colors() {
        return this.colors;
    }

    public HugeLongArray compute() {
        this.getProgressLogger().logMessage(":: Start");
        this.colors = HugeLongArray.newArray((long)this.nodeCount, (AllocationTracker)this.tracker);
        this.colors.setAll(nodeId -> 1000L);
        this.ranIterations = 0L;
        this.nodesToColor.set(0L, this.nodeCount);
        while (this.ranIterations < this.maxIterations && !this.nodesToColor.isEmpty()) {
            this.getProgressLogger().logMessage(String.format(":: Iteration %d :: Start", this.ranIterations + 1L));
            this.assertRunning();
            this.runColoring();
            this.assertRunning();
            this.runValidation();
            ++this.ranIterations;
            if (this.ranIterations < this.maxIterations && !this.nodesToColor.isEmpty()) {
                this.getProgressLogger().reset(this.nodesToColor.cardinality() * 2L);
            }
            this.getProgressLogger().logMessage(String.format(":: Iteration %d :: Finished", this.ranIterations));
        }
        this.didConverge = this.ranIterations < this.maxIterations;
        this.getProgressLogger().logMessage(":: Finished");
        return this.colors();
    }

    private void runColoring() {
        long nodeCount = this.graph.nodeCount();
        long approximateRelationshipCount = BitUtil.ceilDiv((long)this.graph.relationshipCount(), (long)nodeCount) * this.nodesToColor.cardinality();
        long adjustedBatchSize = ParallelUtil.adjustedBatchSize((long)approximateRelationshipCount, (int)this.concurrency, (long)this.minBatchSize, (long)Integer.MAX_VALUE);
        List degreePartitions = PartitionUtils.degreePartition((PrimitiveLongIterator)new SetBitsIterable(this.nodesToColor).primitiveLongIterator(), (Degrees)this.graph, (long)adjustedBatchSize);
        List steps = degreePartitions.stream().map(partition -> new ColoringStep(this.graph.concurrentCopy(), this.colors, this.nodesToColor, nodeCount, partition.startNode, partition.nodeCount, this.getProgressLogger())).collect(Collectors.toList());
        ParallelUtil.runWithConcurrency((int)this.concurrency, steps, (ExecutorService)this.executor);
    }

    private void runValidation() {
        BitSet nextNodesToColor = new BitSet(this.nodeCount);
        List partitions = PartitionUtils.numberAlignedPartitioning((int)this.concurrency, (long)this.nodeCount, (long)64L);
        List steps = partitions.stream().map(partition -> new ValidationStep(this.graph.concurrentCopy(), this.colors, this.nodesToColor, nextNodesToColor, this.nodeCount, partition.startNode, partition.nodeCount, this.getProgressLogger())).collect(Collectors.toList());
        ParallelUtil.runWithConcurrency((int)this.concurrency, steps, (ExecutorService)this.executor);
        this.nodesToColor = nextNodesToColor;
    }
}

