/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringConfig;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringWriteConfig;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.IterationsConfig;
import org.neo4j.graphalgo.config.WriteConfig;
import org.neo4j.graphalgo.config.WritePropertyConfig;

@Generated(from="K1ColoringWriteConfig", generator="Immutables")
public final class ImmutableK1ColoringWriteConfig
implements K1ColoringWriteConfig {
    private final String username;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    private final int maxIterations;
    private final int batchSize;
    private final int writeConcurrency;
    private final String writeProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableK1ColoringWriteConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableK1ColoringWriteConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableK1ColoringWriteConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.writeProperty = builder.writeProperty;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableK1ColoringWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableK1ColoringWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableK1ColoringWriteConfig(String username, boolean sudo, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        this.initShim.username(username);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return K1ColoringWriteConfig.super.username();
    }

    private boolean sudoInitialize() {
        return K1ColoringWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return K1ColoringWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return K1ColoringWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return K1ColoringWriteConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return K1ColoringWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return K1ColoringWriteConfig.super.nodeLabels();
    }

    private int maxIterationsInitialize() {
        return K1ColoringWriteConfig.super.maxIterations();
    }

    private int batchSizeInitialize() {
        return K1ColoringWriteConfig.super.batchSize();
    }

    private int writeConcurrencyInitialize() {
        return K1ColoringWriteConfig.super.writeConcurrency();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public final ImmutableK1ColoringWriteConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, value, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.maxIterations, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.batchSize, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, value, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, value, this.writeProperty));
    }

    public final ImmutableK1ColoringWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.writeConcurrency, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableK1ColoringWriteConfig && this.equalTo((ImmutableK1ColoringWriteConfig)another);
    }

    private boolean equalTo(ImmutableK1ColoringWriteConfig another) {
        return this.username.equals(another.username) && this.sudo == another.sudo && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && this.maxIterations == another.maxIterations && this.batchSize == another.batchSize && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.batchSize;
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("K1ColoringWriteConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        return builder.append("}").toString();
    }

    public static K1ColoringWriteConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        return ImmutableK1ColoringWriteConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, writeConcurrency, writeProperty);
    }

    public static K1ColoringWriteConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, writeConcurrency, writeProperty));
    }

    public static K1ColoringWriteConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, int writeConcurrency, String writeProperty) {
        return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, writeConcurrency, writeProperty));
    }

    private static ImmutableK1ColoringWriteConfig validate(ImmutableK1ColoringWriteConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static K1ColoringWriteConfig copyOf(K1ColoringWriteConfig instance) {
        if (instance instanceof ImmutableK1ColoringWriteConfig) {
            return (ImmutableK1ColoringWriteConfig)instance;
        }
        return ImmutableK1ColoringWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="K1ColoringWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 4L;
        private static final long OPT_BIT_NODE_LABELS = 8L;
        private static final long OPT_BIT_MAX_ITERATIONS = 16L;
        private static final long OPT_BIT_BATCH_SIZE = 32L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 64L;
        private long initBits = 1L;
        private long optBits;
        private String username;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private int maxIterations;
        private int batchSize;
        private int writeConcurrency;
        private String writeProperty;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(K1ColoringConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(K1ColoringWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
                this.username(instance.username());
            }
            if (object instanceof K1ColoringConfig) {
                instance = (K1ColoringConfig)object;
                this.batchSize(instance.batchSize());
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.username = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.maxIterations = 0;
            this.batchSize = 0;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            return this;
        }

        public K1ColoringWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableK1ColoringWriteConfig.validate(new ImmutableK1ColoringWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build K1ColoringWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="K1ColoringWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableK1ColoringWriteConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableK1ColoringWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableK1ColoringWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableK1ColoringWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableK1ColoringWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(ImmutableK1ColoringWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableK1ColoringWriteConfig.createUnmodifiableList(false, ImmutableK1ColoringWriteConfig.createSafeList(ImmutableK1ColoringWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableK1ColoringWriteConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableK1ColoringWriteConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableK1ColoringWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build K1ColoringWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

