/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringConfig;
import org.neo4j.graphalgo.beta.k1coloring.K1ColoringMutateConfig;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.IterationsConfig;
import org.neo4j.graphalgo.config.MutatePropertyConfig;

@Generated(from="K1ColoringMutateConfig", generator="Immutables")
public final class ImmutableK1ColoringMutateConfig
implements K1ColoringMutateConfig {
    private final String username;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    private final int maxIterations;
    private final int batchSize;
    private final String mutateProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableK1ColoringMutateConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableK1ColoringMutateConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableK1ColoringMutateConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.mutateProperty = builder.mutateProperty;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableK1ColoringMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableK1ColoringMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableK1ColoringMutateConfig(String username, boolean sudo, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        this.initShim.username(username);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.maxIterations(maxIterations);
        this.initShim.batchSize(batchSize);
        this.mutateProperty = mutateProperty;
        this.username = this.initShim.username();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.maxIterations = this.initShim.maxIterations();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return K1ColoringMutateConfig.super.username();
    }

    private boolean sudoInitialize() {
        return K1ColoringMutateConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return K1ColoringMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return K1ColoringMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return K1ColoringMutateConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return K1ColoringMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return K1ColoringMutateConfig.super.nodeLabels();
    }

    private int maxIterationsInitialize() {
        return K1ColoringMutateConfig.super.maxIterations();
    }

    private int batchSizeInitialize() {
        return K1ColoringMutateConfig.super.batchSize();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public final ImmutableK1ColoringMutateConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(newValue, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, value, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(elements, true, false));
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.maxIterations, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.batchSize, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, value, this.mutateProperty));
    }

    public final ImmutableK1ColoringMutateConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this.username, this.sudo, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.maxIterations, this.batchSize, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableK1ColoringMutateConfig && this.equalTo((ImmutableK1ColoringMutateConfig)another);
    }

    private boolean equalTo(ImmutableK1ColoringMutateConfig another) {
        return this.username.equals(another.username) && this.sudo == another.sudo && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && this.maxIterations == another.maxIterations && this.batchSize == another.batchSize && this.mutateProperty.equals(another.mutateProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.batchSize;
        h += (h << 5) + this.mutateProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("K1ColoringMutateConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        builder.append(", ");
        builder.append("mutateProperty=").append(this.mutateProperty);
        return builder.append("}").toString();
    }

    public static K1ColoringMutateConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        return ImmutableK1ColoringMutateConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, mutateProperty);
    }

    public static K1ColoringMutateConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, mutateProperty));
    }

    public static K1ColoringMutateConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, int maxIterations, int batchSize, String mutateProperty) {
        return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, maxIterations, batchSize, mutateProperty));
    }

    private static ImmutableK1ColoringMutateConfig validate(ImmutableK1ColoringMutateConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static K1ColoringMutateConfig copyOf(K1ColoringMutateConfig instance) {
        if (instance instanceof ImmutableK1ColoringMutateConfig) {
            return (ImmutableK1ColoringMutateConfig)instance;
        }
        return ImmutableK1ColoringMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="K1ColoringMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MUTATE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_CONCURRENCY = 2L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 4L;
        private static final long OPT_BIT_NODE_LABELS = 8L;
        private static final long OPT_BIT_MAX_ITERATIONS = 16L;
        private static final long OPT_BIT_BATCH_SIZE = 32L;
        private long initBits = 1L;
        private long optBits;
        private String username;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private int maxIterations;
        private int batchSize;
        private String mutateProperty;

        private Builder() {
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(K1ColoringConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(K1ColoringMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                this.mutateProperty(instance.mutateProperty());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
                this.username(instance.username());
            }
            if (object instanceof K1ColoringConfig) {
                instance = (K1ColoringConfig)object;
                this.batchSize(instance.batchSize());
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 2L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.username = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.maxIterations = 0;
            this.batchSize = 0;
            this.mutateProperty = null;
            return this;
        }

        public K1ColoringMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableK1ColoringMutateConfig.validate(new ImmutableK1ColoringMutateConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mutateProperty");
            }
            return "Cannot build K1ColoringMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="K1ColoringMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte batchSizeBuildStage = 0;
        private int batchSize;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableK1ColoringMutateConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableK1ColoringMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableK1ColoringMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableK1ColoringMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableK1ColoringMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(ImmutableK1ColoringMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableK1ColoringMutateConfig.createUnmodifiableList(false, ImmutableK1ColoringMutateConfig.createSafeList(ImmutableK1ColoringMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableK1ColoringMutateConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableK1ColoringMutateConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            return "Cannot build K1ColoringMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

