/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.graphalgo.api.RelationshipIterator;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;

public final class ColoringStep
implements Runnable {
    public static final int INITIAL_FORBIDDEN_COLORS = 1000;
    private final RelationshipIterator graph;
    private final HugeLongArray colors;
    private final BitSet nodesToColor;
    private final BitSet forbiddenColors;
    private final long offset;
    private final ProgressLogger progressLogger;
    private final long batchEnd;
    private final long[] resetMask;

    public ColoringStep(RelationshipIterator graph, HugeLongArray colors, BitSet nodesToColor, long nodeCount, long offset, long batchSize, ProgressLogger progressLogger) {
        this.graph = graph;
        this.colors = colors;
        this.nodesToColor = nodesToColor;
        this.offset = offset;
        this.batchEnd = Math.min(offset + batchSize, nodeCount);
        this.forbiddenColors = new BitSet(1000L);
        this.resetMask = new long[1000];
        this.progressLogger = progressLogger;
    }

    @Override
    public void run() {
        for (long nodeId = this.offset; nodeId < this.batchEnd; ++nodeId) {
            if (!this.nodesToColor.get(nodeId)) continue;
            this.resetForbiddenColors();
            this.graph.forEachRelationship(nodeId, (s, target) -> {
                if (s != target) {
                    this.forbiddenColors.set(this.colors.get(target));
                }
                return true;
            });
            long nextColor = 0L;
            while (this.forbiddenColors.get(nextColor)) {
                ++nextColor;
            }
            this.colors.set(nodeId, nextColor);
            this.progressLogger.logProgress();
        }
    }

    private void resetForbiddenColors() {
        for (int i = 0; i <= this.forbiddenColors.bits.length; i += this.resetMask.length) {
            System.arraycopy(this.resetMask, 0, this.forbiddenColors.bits, i, Math.min(this.forbiddenColors.bits.length - i, 1000));
            this.forbiddenColors.wlen = 0;
        }
    }
}

